/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_4.discovery.v1;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.kubernetes.api.model.v5_4.ObjectReference;
import io.fabric8.kubernetes.api.model.v5_4.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_4.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.v5_4.discovery.v1.Endpoint;
import io.fabric8.kubernetes.api.model.v5_4.discovery.v1.EndpointConditions;
import io.fabric8.kubernetes.api.model.v5_4.discovery.v1.EndpointConditionsBuilder;
import io.fabric8.kubernetes.api.model.v5_4.discovery.v1.EndpointConditionsFluentImpl;
import io.fabric8.kubernetes.api.model.v5_4.discovery.v1.EndpointFluent;
import io.fabric8.kubernetes.api.model.v5_4.discovery.v1.EndpointHints;
import io.fabric8.kubernetes.api.model.v5_4.discovery.v1.EndpointHintsBuilder;
import io.fabric8.kubernetes.api.model.v5_4.discovery.v1.EndpointHintsFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointFluentImpl<A extends EndpointFluent<A>>
extends BaseFluent<A>
implements EndpointFluent<A> {
    private List<String> addresses = new ArrayList<String>();
    private EndpointConditionsBuilder conditions;
    private Map<String, String> deprecatedTopology;
    private EndpointHintsBuilder hints;
    private String hostname;
    private String nodeName;
    private ObjectReferenceBuilder targetRef;
    private String zone;

    public EndpointFluentImpl() {
    }

    public EndpointFluentImpl(Endpoint instance) {
        this.withAddresses(instance.getAddresses());
        this.withConditions(instance.getConditions());
        this.withDeprecatedTopology(instance.getDeprecatedTopology());
        this.withHints(instance.getHints());
        this.withHostname(instance.getHostname());
        this.withNodeName(instance.getNodeName());
        this.withTargetRef(instance.getTargetRef());
        this.withZone(instance.getZone());
    }

    @Override
    public A addToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAddresses(int index, String item) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        this.addresses.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAddresses(String ... items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAddresses(Collection<String> items) {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        for (String item : items) {
            this.addresses.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAddresses(String ... items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAddresses(Collection<String> items) {
        for (String item : items) {
            if (this.addresses == null) continue;
            this.addresses.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAddresses() {
        return this.addresses;
    }

    @Override
    public String getAddress(int index) {
        return this.addresses.get(index);
    }

    @Override
    public String getFirstAddress() {
        return this.addresses.get(0);
    }

    @Override
    public String getLastAddress() {
        return this.addresses.get(this.addresses.size() - 1);
    }

    @Override
    public String getMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAddress(Predicate<String> predicate) {
        for (String item : this.addresses) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAddresses(List<String> addresses) {
        if (this.addresses != null) {
            this._visitables.get("addresses").removeAll(this.addresses);
        }
        if (addresses != null) {
            this.addresses = new ArrayList<String>();
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        } else {
            this.addresses = null;
        }
        return (A)this;
    }

    @Override
    public A withAddresses(String ... addresses) {
        if (this.addresses != null) {
            this.addresses.clear();
        }
        if (addresses != null) {
            for (String item : addresses) {
                this.addToAddresses(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAddresses() {
        return this.addresses != null && !this.addresses.isEmpty();
    }

    @Override
    public A addNewAddress(String arg0) {
        return this.addToAddresses(new String(arg0));
    }

    @Override
    @Deprecated
    public EndpointConditions getConditions() {
        return this.conditions != null ? this.conditions.build() : null;
    }

    @Override
    public EndpointConditions buildConditions() {
        return this.conditions != null ? this.conditions.build() : null;
    }

    @Override
    public A withConditions(EndpointConditions conditions) {
        this._visitables.get("conditions").remove(this.conditions);
        if (conditions != null) {
            this.conditions = new EndpointConditionsBuilder(conditions);
            this._visitables.get("conditions").add(this.conditions);
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null;
    }

    @Override
    public A withNewConditions(Boolean ready, Boolean serving, Boolean terminating) {
        return this.withConditions(new EndpointConditions(ready, serving, terminating));
    }

    @Override
    public EndpointFluent.ConditionsNested<A> withNewConditions() {
        return new ConditionsNestedImpl();
    }

    @Override
    public EndpointFluent.ConditionsNested<A> withNewConditionsLike(EndpointConditions item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public EndpointFluent.ConditionsNested<A> editConditions() {
        return this.withNewConditionsLike(this.getConditions());
    }

    @Override
    public EndpointFluent.ConditionsNested<A> editOrNewConditions() {
        return this.withNewConditionsLike(this.getConditions() != null ? this.getConditions() : new EndpointConditionsBuilder().build());
    }

    @Override
    public EndpointFluent.ConditionsNested<A> editOrNewConditionsLike(EndpointConditions item) {
        return this.withNewConditionsLike(this.getConditions() != null ? this.getConditions() : item);
    }

    @Override
    public A addToDeprecatedTopology(String key, String value) {
        if (this.deprecatedTopology == null && key != null && value != null) {
            this.deprecatedTopology = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.deprecatedTopology.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToDeprecatedTopology(Map<String, String> map) {
        if (this.deprecatedTopology == null && map != null) {
            this.deprecatedTopology = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.deprecatedTopology.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromDeprecatedTopology(String key) {
        if (this.deprecatedTopology == null) {
            return (A)this;
        }
        if (key != null && this.deprecatedTopology != null) {
            this.deprecatedTopology.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromDeprecatedTopology(Map<String, String> map) {
        if (this.deprecatedTopology == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.deprecatedTopology == null) continue;
                this.deprecatedTopology.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getDeprecatedTopology() {
        return this.deprecatedTopology;
    }

    @Override
    public <K, V> A withDeprecatedTopology(Map<String, String> deprecatedTopology) {
        this.deprecatedTopology = deprecatedTopology == null ? null : new LinkedHashMap<String, String>(deprecatedTopology);
        return (A)this;
    }

    @Override
    public Boolean hasDeprecatedTopology() {
        return this.deprecatedTopology != null;
    }

    @Override
    @Deprecated
    public EndpointHints getHints() {
        return this.hints != null ? this.hints.build() : null;
    }

    @Override
    public EndpointHints buildHints() {
        return this.hints != null ? this.hints.build() : null;
    }

    @Override
    public A withHints(EndpointHints hints) {
        this._visitables.get("hints").remove(this.hints);
        if (hints != null) {
            this.hints = new EndpointHintsBuilder(hints);
            this._visitables.get("hints").add(this.hints);
        }
        return (A)this;
    }

    @Override
    public Boolean hasHints() {
        return this.hints != null;
    }

    @Override
    public EndpointFluent.HintsNested<A> withNewHints() {
        return new HintsNestedImpl();
    }

    @Override
    public EndpointFluent.HintsNested<A> withNewHintsLike(EndpointHints item) {
        return new HintsNestedImpl(item);
    }

    @Override
    public EndpointFluent.HintsNested<A> editHints() {
        return this.withNewHintsLike(this.getHints());
    }

    @Override
    public EndpointFluent.HintsNested<A> editOrNewHints() {
        return this.withNewHintsLike(this.getHints() != null ? this.getHints() : new EndpointHintsBuilder().build());
    }

    @Override
    public EndpointFluent.HintsNested<A> editOrNewHintsLike(EndpointHints item) {
        return this.withNewHintsLike(this.getHints() != null ? this.getHints() : item);
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public A withHostname(String hostname) {
        this.hostname = hostname;
        return (A)this;
    }

    @Override
    public Boolean hasHostname() {
        return this.hostname != null;
    }

    @Override
    @Deprecated
    public A withNewHostname(String arg0) {
        return this.withHostname(new String(arg0));
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    @Override
    public A withNodeName(String nodeName) {
        this.nodeName = nodeName;
        return (A)this;
    }

    @Override
    public Boolean hasNodeName() {
        return this.nodeName != null;
    }

    @Override
    @Deprecated
    public A withNewNodeName(String arg0) {
        return this.withNodeName(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectReference getTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public ObjectReference buildTargetRef() {
        return this.targetRef != null ? this.targetRef.build() : null;
    }

    @Override
    public A withTargetRef(ObjectReference targetRef) {
        this._visitables.get("targetRef").remove(this.targetRef);
        if (targetRef != null) {
            this.targetRef = new ObjectReferenceBuilder(targetRef);
            this._visitables.get("targetRef").add(this.targetRef);
        }
        return (A)this;
    }

    @Override
    public Boolean hasTargetRef() {
        return this.targetRef != null;
    }

    @Override
    public EndpointFluent.TargetRefNested<A> withNewTargetRef() {
        return new TargetRefNestedImpl();
    }

    @Override
    public EndpointFluent.TargetRefNested<A> withNewTargetRefLike(ObjectReference item) {
        return new TargetRefNestedImpl(item);
    }

    @Override
    public EndpointFluent.TargetRefNested<A> editTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef());
    }

    @Override
    public EndpointFluent.TargetRefNested<A> editOrNewTargetRef() {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : new ObjectReferenceBuilder().build());
    }

    @Override
    public EndpointFluent.TargetRefNested<A> editOrNewTargetRefLike(ObjectReference item) {
        return this.withNewTargetRefLike(this.getTargetRef() != null ? this.getTargetRef() : item);
    }

    @Override
    public String getZone() {
        return this.zone;
    }

    @Override
    public A withZone(String zone) {
        this.zone = zone;
        return (A)this;
    }

    @Override
    public Boolean hasZone() {
        return this.zone != null;
    }

    @Override
    @Deprecated
    public A withNewZone(String arg0) {
        return this.withZone(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointFluentImpl that = (EndpointFluentImpl)o;
        if (this.addresses != null ? !this.addresses.equals(that.addresses) : that.addresses != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.deprecatedTopology != null ? !this.deprecatedTopology.equals(that.deprecatedTopology) : that.deprecatedTopology != null) {
            return false;
        }
        if (this.hints != null ? !this.hints.equals(that.hints) : that.hints != null) {
            return false;
        }
        if (this.hostname != null ? !this.hostname.equals(that.hostname) : that.hostname != null) {
            return false;
        }
        if (this.nodeName != null ? !this.nodeName.equals(that.nodeName) : that.nodeName != null) {
            return false;
        }
        if (this.targetRef != null ? !this.targetRef.equals(that.targetRef) : that.targetRef != null) {
            return false;
        }
        return !(this.zone != null ? !this.zone.equals(that.zone) : that.zone != null);
    }

    public int hashCode() {
        return Objects.hash(this.addresses, this.conditions, this.deprecatedTopology, this.hints, this.hostname, this.nodeName, this.targetRef, this.zone, super.hashCode());
    }

    public class TargetRefNestedImpl<N>
    extends ObjectReferenceFluentImpl<EndpointFluent.TargetRefNested<N>>
    implements EndpointFluent.TargetRefNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        TargetRefNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        TargetRefNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointFluentImpl.this.withTargetRef(this.builder.build());
        }

        @Override
        public N endTargetRef() {
            return this.and();
        }
    }

    public class HintsNestedImpl<N>
    extends EndpointHintsFluentImpl<EndpointFluent.HintsNested<N>>
    implements EndpointFluent.HintsNested<N>,
    Nested<N> {
        private final EndpointHintsBuilder builder;

        HintsNestedImpl(EndpointHints item) {
            this.builder = new EndpointHintsBuilder(this, item);
        }

        HintsNestedImpl() {
            this.builder = new EndpointHintsBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointFluentImpl.this.withHints(this.builder.build());
        }

        @Override
        public N endHints() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends EndpointConditionsFluentImpl<EndpointFluent.ConditionsNested<N>>
    implements EndpointFluent.ConditionsNested<N>,
    Nested<N> {
        private final EndpointConditionsBuilder builder;

        ConditionsNestedImpl(EndpointConditions item) {
            this.builder = new EndpointConditionsBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.builder = new EndpointConditionsBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointFluentImpl.this.withConditions(this.builder.build());
        }

        @Override
        public N endConditions() {
            return this.and();
        }
    }
}

