/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_4.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.kubernetes.api.model.v5_4.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_4.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_4.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_4.Quantity;
import io.fabric8.kubernetes.api.model.v5_4.autoscaling.v2beta1.ExternalMetricSource;
import io.fabric8.kubernetes.api.model.v5_4.autoscaling.v2beta1.ExternalMetricSourceFluent;
import java.util.Objects;

public class ExternalMetricSourceFluentImpl<A extends ExternalMetricSourceFluent<A>>
extends BaseFluent<A>
implements ExternalMetricSourceFluent<A> {
    private String metricName;
    private LabelSelectorBuilder metricSelector;
    private Quantity targetAverageValue;
    private Quantity targetValue;

    public ExternalMetricSourceFluentImpl() {
    }

    public ExternalMetricSourceFluentImpl(ExternalMetricSource instance) {
        this.withMetricName(instance.getMetricName());
        this.withMetricSelector(instance.getMetricSelector());
        this.withTargetAverageValue(instance.getTargetAverageValue());
        this.withTargetValue(instance.getTargetValue());
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    @Deprecated
    public A withNewMetricName(String arg0) {
        return this.withMetricName(new String(arg0));
    }

    @Override
    @Deprecated
    public LabelSelector getMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public LabelSelector buildMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public A withMetricSelector(LabelSelector metricSelector) {
        this._visitables.get("metricSelector").remove(this.metricSelector);
        if (metricSelector != null) {
            this.metricSelector = new LabelSelectorBuilder(metricSelector);
            this._visitables.get("metricSelector").add(this.metricSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNestedImpl();
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
        return new MetricSelectorNestedImpl(item);
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector());
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : item);
    }

    @Override
    public Quantity getTargetAverageValue() {
        return this.targetAverageValue;
    }

    @Override
    public A withTargetAverageValue(Quantity targetAverageValue) {
        this.targetAverageValue = targetAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetAverageValue() {
        return this.targetAverageValue != null;
    }

    @Override
    public A withNewTargetAverageValue(String amount, String format) {
        return this.withTargetAverageValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetAverageValue(String amount) {
        return this.withTargetAverageValue(new Quantity(amount));
    }

    @Override
    public Quantity getTargetValue() {
        return this.targetValue;
    }

    @Override
    public A withTargetValue(Quantity targetValue) {
        this.targetValue = targetValue;
        return (A)this;
    }

    @Override
    public Boolean hasTargetValue() {
        return this.targetValue != null;
    }

    @Override
    public A withNewTargetValue(String amount, String format) {
        return this.withTargetValue(new Quantity(amount, format));
    }

    @Override
    public A withNewTargetValue(String amount) {
        return this.withTargetValue(new Quantity(amount));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricSourceFluentImpl that = (ExternalMetricSourceFluentImpl)o;
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        if (this.metricSelector != null ? !this.metricSelector.equals(that.metricSelector) : that.metricSelector != null) {
            return false;
        }
        if (this.targetAverageValue != null ? !this.targetAverageValue.equals(that.targetAverageValue) : that.targetAverageValue != null) {
            return false;
        }
        return !(this.targetValue != null ? !this.targetValue.equals(that.targetValue) : that.targetValue != null);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.metricSelector, this.targetAverageValue, this.targetValue, super.hashCode());
    }

    public class MetricSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ExternalMetricSourceFluent.MetricSelectorNested<N>>
    implements ExternalMetricSourceFluent.MetricSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        MetricSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        MetricSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalMetricSourceFluentImpl.this.withMetricSelector(this.builder.build());
        }

        @Override
        public N endMetricSelector() {
            return this.and();
        }
    }
}

