/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_4.VolumeMount;
import io.fabric8.kubernetes.api.model.v5_4.VolumeMountFluent;
import java.util.Objects;

public class VolumeMountFluentImpl<A extends VolumeMountFluent<A>>
extends BaseFluent<A>
implements VolumeMountFluent<A> {
    private String mountPath;
    private String mountPropagation;
    private String name;
    private Boolean readOnly;
    private String subPath;
    private String subPathExpr;

    public VolumeMountFluentImpl() {
    }

    public VolumeMountFluentImpl(VolumeMount instance) {
        this.withMountPath(instance.getMountPath());
        this.withMountPropagation(instance.getMountPropagation());
        this.withName(instance.getName());
        this.withReadOnly(instance.getReadOnly());
        this.withSubPath(instance.getSubPath());
        this.withSubPathExpr(instance.getSubPathExpr());
    }

    @Override
    public String getMountPath() {
        return this.mountPath;
    }

    @Override
    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)this;
    }

    @Override
    public Boolean hasMountPath() {
        return this.mountPath != null;
    }

    @Override
    @Deprecated
    public A withNewMountPath(String arg0) {
        return this.withMountPath(new String(arg0));
    }

    @Override
    public String getMountPropagation() {
        return this.mountPropagation;
    }

    @Override
    public A withMountPropagation(String mountPropagation) {
        this.mountPropagation = mountPropagation;
        return (A)this;
    }

    @Override
    public Boolean hasMountPropagation() {
        return this.mountPropagation != null;
    }

    @Override
    @Deprecated
    public A withNewMountPropagation(String arg0) {
        return this.withMountPropagation(new String(arg0));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public A withNewName(String arg0) {
        return this.withName(new String(arg0));
    }

    @Override
    public Boolean getReadOnly() {
        return this.readOnly;
    }

    @Override
    public A withReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
        return (A)this;
    }

    @Override
    public Boolean hasReadOnly() {
        return this.readOnly != null;
    }

    @Override
    public String getSubPath() {
        return this.subPath;
    }

    @Override
    public A withSubPath(String subPath) {
        this.subPath = subPath;
        return (A)this;
    }

    @Override
    public Boolean hasSubPath() {
        return this.subPath != null;
    }

    @Override
    @Deprecated
    public A withNewSubPath(String arg0) {
        return this.withSubPath(new String(arg0));
    }

    @Override
    public String getSubPathExpr() {
        return this.subPathExpr;
    }

    @Override
    public A withSubPathExpr(String subPathExpr) {
        this.subPathExpr = subPathExpr;
        return (A)this;
    }

    @Override
    public Boolean hasSubPathExpr() {
        return this.subPathExpr != null;
    }

    @Override
    @Deprecated
    public A withNewSubPathExpr(String arg0) {
        return this.withSubPathExpr(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VolumeMountFluentImpl that = (VolumeMountFluentImpl)o;
        if (this.mountPath != null ? !this.mountPath.equals(that.mountPath) : that.mountPath != null) {
            return false;
        }
        if (this.mountPropagation != null ? !this.mountPropagation.equals(that.mountPropagation) : that.mountPropagation != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.readOnly != null ? !this.readOnly.equals(that.readOnly) : that.readOnly != null) {
            return false;
        }
        if (this.subPath != null ? !this.subPath.equals(that.subPath) : that.subPath != null) {
            return false;
        }
        return !(this.subPathExpr != null ? !this.subPathExpr.equals(that.subPathExpr) : that.subPathExpr != null);
    }

    public int hashCode() {
        return Objects.hash(this.mountPath, this.mountPropagation, this.name, this.readOnly, this.subPath, this.subPathExpr, super.hashCode());
    }
}

