/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_4.Cluster;
import io.fabric8.kubernetes.api.model.v5_4.ClusterFluent;
import io.fabric8.kubernetes.api.model.v5_4.ClusterFluentImpl;
import java.util.Objects;

public class ClusterBuilder
extends ClusterFluentImpl<ClusterBuilder>
implements VisitableBuilder<Cluster, ClusterBuilder> {
    ClusterFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterBuilder() {
        this(true);
    }

    public ClusterBuilder(Boolean validationEnabled) {
        this(new Cluster(), validationEnabled);
    }

    public ClusterBuilder(ClusterFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Cluster(), validationEnabled);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Cluster instance) {
        this(fluent, instance, true);
    }

    public ClusterBuilder(ClusterFluent<?> fluent, Cluster instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCertificateAuthority(instance.getCertificateAuthority());
        fluent.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        fluent.withExtensions(instance.getExtensions());
        fluent.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        fluent.withProxyUrl(instance.getProxyUrl());
        fluent.withServer(instance.getServer());
        fluent.withTlsServerName(instance.getTlsServerName());
        this.validationEnabled = validationEnabled;
    }

    public ClusterBuilder(Cluster instance) {
        this(instance, (Boolean)true);
    }

    public ClusterBuilder(Cluster instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCertificateAuthority(instance.getCertificateAuthority());
        this.withCertificateAuthorityData(instance.getCertificateAuthorityData());
        this.withExtensions(instance.getExtensions());
        this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify());
        this.withProxyUrl(instance.getProxyUrl());
        this.withServer(instance.getServer());
        this.withTlsServerName(instance.getTlsServerName());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Cluster build() {
        Cluster buildable = new Cluster(this.fluent.getCertificateAuthority(), this.fluent.getCertificateAuthorityData(), this.fluent.getExtensions(), this.fluent.getInsecureSkipTlsVerify(), this.fluent.getProxyUrl(), this.fluent.getServer(), this.fluent.getTlsServerName());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterBuilder that = (ClusterBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

