/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4.monitoring.v1;

import io.fabric8.kubernetes.api.builder.v5_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.Endpoint;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.EndpointFluent;
import io.fabric8.openshift.api.model.v5_4.monitoring.v1.EndpointFluentImpl;
import java.util.Objects;

public class EndpointBuilder
extends EndpointFluentImpl<EndpointBuilder>
implements VisitableBuilder<Endpoint, EndpointBuilder> {
    EndpointFluent<?> fluent;
    Boolean validationEnabled;

    public EndpointBuilder() {
        this(true);
    }

    public EndpointBuilder(Boolean validationEnabled) {
        this(new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Endpoint(), validationEnabled);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Endpoint instance) {
        this(fluent, instance, true);
    }

    public EndpointBuilder(EndpointFluent<?> fluent, Endpoint instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBasicAuth(instance.getBasicAuth());
        fluent.withBearerTokenFile(instance.getBearerTokenFile());
        fluent.withBearerTokenSecret(instance.getBearerTokenSecret());
        fluent.withHonorLabels(instance.getHonorLabels());
        fluent.withHonorTimestamps(instance.getHonorTimestamps());
        fluent.withInterval(instance.getInterval());
        fluent.withMetricRelabelings(instance.getMetricRelabelings());
        fluent.withParams(instance.getParams());
        fluent.withPath(instance.getPath());
        fluent.withPort(instance.getPort());
        fluent.withProxyUrl(instance.getProxyUrl());
        fluent.withRelabelings(instance.getRelabelings());
        fluent.withScheme(instance.getScheme());
        fluent.withScrapeTimeout(instance.getScrapeTimeout());
        fluent.withTargetPort(instance.getTargetPort());
        fluent.withTlsConfig(instance.getTlsConfig());
        this.validationEnabled = validationEnabled;
    }

    public EndpointBuilder(Endpoint instance) {
        this(instance, (Boolean)true);
    }

    public EndpointBuilder(Endpoint instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBasicAuth(instance.getBasicAuth());
        this.withBearerTokenFile(instance.getBearerTokenFile());
        this.withBearerTokenSecret(instance.getBearerTokenSecret());
        this.withHonorLabels(instance.getHonorLabels());
        this.withHonorTimestamps(instance.getHonorTimestamps());
        this.withInterval(instance.getInterval());
        this.withMetricRelabelings(instance.getMetricRelabelings());
        this.withParams(instance.getParams());
        this.withPath(instance.getPath());
        this.withPort(instance.getPort());
        this.withProxyUrl(instance.getProxyUrl());
        this.withRelabelings(instance.getRelabelings());
        this.withScheme(instance.getScheme());
        this.withScrapeTimeout(instance.getScrapeTimeout());
        this.withTargetPort(instance.getTargetPort());
        this.withTlsConfig(instance.getTlsConfig());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Endpoint build() {
        Endpoint buildable = new Endpoint(this.fluent.getBasicAuth(), this.fluent.getBearerTokenFile(), this.fluent.getBearerTokenSecret(), this.fluent.getHonorLabels(), this.fluent.getHonorTimestamps(), this.fluent.getInterval(), this.fluent.getMetricRelabelings(), this.fluent.getParams(), this.fluent.getPath(), this.fluent.getPort(), this.fluent.getProxyUrl(), this.fluent.getRelabelings(), this.fluent.getScheme(), this.fluent.getScrapeTimeout(), this.fluent.getTargetPort(), this.fluent.getTlsConfig());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        EndpointBuilder that = (EndpointBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

