/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.openshift.api.model.v5_4.InfrastructureStatus;
import io.fabric8.openshift.api.model.v5_4.InfrastructureStatusFluent;
import io.fabric8.openshift.api.model.v5_4.PlatformStatus;
import io.fabric8.openshift.api.model.v5_4.PlatformStatusBuilder;
import io.fabric8.openshift.api.model.v5_4.PlatformStatusFluentImpl;
import java.util.Objects;

public class InfrastructureStatusFluentImpl<A extends InfrastructureStatusFluent<A>>
extends BaseFluent<A>
implements InfrastructureStatusFluent<A> {
    private String apiServerInternalURI;
    private String apiServerURL;
    private String etcdDiscoveryDomain;
    private String infrastructureName;
    private String platform;
    private PlatformStatusBuilder platformStatus;

    public InfrastructureStatusFluentImpl() {
    }

    public InfrastructureStatusFluentImpl(InfrastructureStatus instance) {
        this.withApiServerInternalURI(instance.getApiServerInternalURI());
        this.withApiServerURL(instance.getApiServerURL());
        this.withEtcdDiscoveryDomain(instance.getEtcdDiscoveryDomain());
        this.withInfrastructureName(instance.getInfrastructureName());
        this.withPlatform(instance.getPlatform());
        this.withPlatformStatus(instance.getPlatformStatus());
    }

    @Override
    public String getApiServerInternalURI() {
        return this.apiServerInternalURI;
    }

    @Override
    public A withApiServerInternalURI(String apiServerInternalURI) {
        this.apiServerInternalURI = apiServerInternalURI;
        return (A)this;
    }

    @Override
    public Boolean hasApiServerInternalURI() {
        return this.apiServerInternalURI != null;
    }

    @Override
    @Deprecated
    public A withNewApiServerInternalURI(String arg0) {
        return this.withApiServerInternalURI(new String(arg0));
    }

    @Override
    public String getApiServerURL() {
        return this.apiServerURL;
    }

    @Override
    public A withApiServerURL(String apiServerURL) {
        this.apiServerURL = apiServerURL;
        return (A)this;
    }

    @Override
    public Boolean hasApiServerURL() {
        return this.apiServerURL != null;
    }

    @Override
    @Deprecated
    public A withNewApiServerURL(String arg0) {
        return this.withApiServerURL(new String(arg0));
    }

    @Override
    public String getEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain;
    }

    @Override
    public A withEtcdDiscoveryDomain(String etcdDiscoveryDomain) {
        this.etcdDiscoveryDomain = etcdDiscoveryDomain;
        return (A)this;
    }

    @Override
    public Boolean hasEtcdDiscoveryDomain() {
        return this.etcdDiscoveryDomain != null;
    }

    @Override
    @Deprecated
    public A withNewEtcdDiscoveryDomain(String arg0) {
        return this.withEtcdDiscoveryDomain(new String(arg0));
    }

    @Override
    public String getInfrastructureName() {
        return this.infrastructureName;
    }

    @Override
    public A withInfrastructureName(String infrastructureName) {
        this.infrastructureName = infrastructureName;
        return (A)this;
    }

    @Override
    public Boolean hasInfrastructureName() {
        return this.infrastructureName != null;
    }

    @Override
    @Deprecated
    public A withNewInfrastructureName(String arg0) {
        return this.withInfrastructureName(new String(arg0));
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    @Override
    public A withPlatform(String platform) {
        this.platform = platform;
        return (A)this;
    }

    @Override
    public Boolean hasPlatform() {
        return this.platform != null;
    }

    @Override
    @Deprecated
    public A withNewPlatform(String arg0) {
        return this.withPlatform(new String(arg0));
    }

    @Override
    @Deprecated
    public PlatformStatus getPlatformStatus() {
        return this.platformStatus != null ? this.platformStatus.build() : null;
    }

    @Override
    public PlatformStatus buildPlatformStatus() {
        return this.platformStatus != null ? this.platformStatus.build() : null;
    }

    @Override
    public A withPlatformStatus(PlatformStatus platformStatus) {
        this._visitables.get("platformStatus").remove(this.platformStatus);
        if (platformStatus != null) {
            this.platformStatus = new PlatformStatusBuilder(platformStatus);
            this._visitables.get("platformStatus").add(this.platformStatus);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPlatformStatus() {
        return this.platformStatus != null;
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatus() {
        return new PlatformStatusNestedImpl();
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> withNewPlatformStatusLike(PlatformStatus item) {
        return new PlatformStatusNestedImpl(item);
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editPlatformStatus() {
        return this.withNewPlatformStatusLike(this.getPlatformStatus());
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatus() {
        return this.withNewPlatformStatusLike(this.getPlatformStatus() != null ? this.getPlatformStatus() : new PlatformStatusBuilder().build());
    }

    @Override
    public InfrastructureStatusFluent.PlatformStatusNested<A> editOrNewPlatformStatusLike(PlatformStatus item) {
        return this.withNewPlatformStatusLike(this.getPlatformStatus() != null ? this.getPlatformStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InfrastructureStatusFluentImpl that = (InfrastructureStatusFluentImpl)o;
        if (this.apiServerInternalURI != null ? !this.apiServerInternalURI.equals(that.apiServerInternalURI) : that.apiServerInternalURI != null) {
            return false;
        }
        if (this.apiServerURL != null ? !this.apiServerURL.equals(that.apiServerURL) : that.apiServerURL != null) {
            return false;
        }
        if (this.etcdDiscoveryDomain != null ? !this.etcdDiscoveryDomain.equals(that.etcdDiscoveryDomain) : that.etcdDiscoveryDomain != null) {
            return false;
        }
        if (this.infrastructureName != null ? !this.infrastructureName.equals(that.infrastructureName) : that.infrastructureName != null) {
            return false;
        }
        if (this.platform != null ? !this.platform.equals(that.platform) : that.platform != null) {
            return false;
        }
        return !(this.platformStatus != null ? !this.platformStatus.equals(that.platformStatus) : that.platformStatus != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiServerInternalURI, this.apiServerURL, this.etcdDiscoveryDomain, this.infrastructureName, this.platform, this.platformStatus, super.hashCode());
    }

    public class PlatformStatusNestedImpl<N>
    extends PlatformStatusFluentImpl<InfrastructureStatusFluent.PlatformStatusNested<N>>
    implements InfrastructureStatusFluent.PlatformStatusNested<N>,
    Nested<N> {
        private final PlatformStatusBuilder builder;

        PlatformStatusNestedImpl(PlatformStatus item) {
            this.builder = new PlatformStatusBuilder(this, item);
        }

        PlatformStatusNestedImpl() {
            this.builder = new PlatformStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)InfrastructureStatusFluentImpl.this.withPlatformStatus(this.builder.build());
        }

        @Override
        public N endPlatformStatus() {
            return this.and();
        }
    }
}

