/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.kubernetes.api.model.v5_4.ObjectReference;
import io.fabric8.kubernetes.api.model.v5_4.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.v5_4.ObjectReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_4.DeploymentTriggerImageChangeParams;
import io.fabric8.openshift.api.model.v5_4.DeploymentTriggerImageChangeParamsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DeploymentTriggerImageChangeParamsFluentImpl<A extends DeploymentTriggerImageChangeParamsFluent<A>>
extends BaseFluent<A>
implements DeploymentTriggerImageChangeParamsFluent<A> {
    private Boolean automatic;
    private List<String> containerNames = new ArrayList<String>();
    private ObjectReferenceBuilder from;
    private String lastTriggeredImage;

    public DeploymentTriggerImageChangeParamsFluentImpl() {
    }

    public DeploymentTriggerImageChangeParamsFluentImpl(DeploymentTriggerImageChangeParams instance) {
        this.withAutomatic(instance.getAutomatic());
        this.withContainerNames(instance.getContainerNames());
        this.withFrom(instance.getFrom());
        this.withLastTriggeredImage(instance.getLastTriggeredImage());
    }

    @Override
    public Boolean getAutomatic() {
        return this.automatic;
    }

    @Override
    public A withAutomatic(Boolean automatic) {
        this.automatic = automatic;
        return (A)this;
    }

    @Override
    public Boolean hasAutomatic() {
        return this.automatic != null;
    }

    @Override
    public A addToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.add(index, item);
        return (A)this;
    }

    @Override
    public A setToContainerNames(int index, String item) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        this.containerNames.set(index, item);
        return (A)this;
    }

    @Override
    public A addToContainerNames(String ... items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToContainerNames(Collection<String> items) {
        if (this.containerNames == null) {
            this.containerNames = new ArrayList<String>();
        }
        for (String item : items) {
            this.containerNames.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromContainerNames(String ... items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromContainerNames(Collection<String> items) {
        for (String item : items) {
            if (this.containerNames == null) continue;
            this.containerNames.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getContainerNames() {
        return this.containerNames;
    }

    @Override
    public String getContainerName(int index) {
        return this.containerNames.get(index);
    }

    @Override
    public String getFirstContainerName() {
        return this.containerNames.get(0);
    }

    @Override
    public String getLastContainerName() {
        return this.containerNames.get(this.containerNames.size() - 1);
    }

    @Override
    public String getMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingContainerName(Predicate<String> predicate) {
        for (String item : this.containerNames) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withContainerNames(List<String> containerNames) {
        if (this.containerNames != null) {
            this._visitables.get("containerNames").removeAll(this.containerNames);
        }
        if (containerNames != null) {
            this.containerNames = new ArrayList<String>();
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        } else {
            this.containerNames = null;
        }
        return (A)this;
    }

    @Override
    public A withContainerNames(String ... containerNames) {
        if (this.containerNames != null) {
            this.containerNames.clear();
        }
        if (containerNames != null) {
            for (String item : containerNames) {
                this.addToContainerNames(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasContainerNames() {
        return this.containerNames != null && !this.containerNames.isEmpty();
    }

    @Override
    public A addNewContainerName(String arg0) {
        return this.addToContainerNames(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectReference getFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public ObjectReference buildFrom() {
        return this.from != null ? this.from.build() : null;
    }

    @Override
    public A withFrom(ObjectReference from) {
        this._visitables.get("from").remove(this.from);
        if (from != null) {
            this.from = new ObjectReferenceBuilder(from);
            this._visitables.get("from").add(this.from);
        }
        return (A)this;
    }

    @Override
    public Boolean hasFrom() {
        return this.from != null;
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFrom() {
        return new FromNestedImpl();
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> withNewFromLike(ObjectReference item) {
        return new FromNestedImpl(item);
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editFrom() {
        return this.withNewFromLike(this.getFrom());
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editOrNewFrom() {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : new ObjectReferenceBuilder().build());
    }

    @Override
    public DeploymentTriggerImageChangeParamsFluent.FromNested<A> editOrNewFromLike(ObjectReference item) {
        return this.withNewFromLike(this.getFrom() != null ? this.getFrom() : item);
    }

    @Override
    public String getLastTriggeredImage() {
        return this.lastTriggeredImage;
    }

    @Override
    public A withLastTriggeredImage(String lastTriggeredImage) {
        this.lastTriggeredImage = lastTriggeredImage;
        return (A)this;
    }

    @Override
    public Boolean hasLastTriggeredImage() {
        return this.lastTriggeredImage != null;
    }

    @Override
    @Deprecated
    public A withNewLastTriggeredImage(String arg0) {
        return this.withLastTriggeredImage(new String(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeploymentTriggerImageChangeParamsFluentImpl that = (DeploymentTriggerImageChangeParamsFluentImpl)o;
        if (this.automatic != null ? !this.automatic.equals(that.automatic) : that.automatic != null) {
            return false;
        }
        if (this.containerNames != null ? !this.containerNames.equals(that.containerNames) : that.containerNames != null) {
            return false;
        }
        if (this.from != null ? !this.from.equals(that.from) : that.from != null) {
            return false;
        }
        return !(this.lastTriggeredImage != null ? !this.lastTriggeredImage.equals(that.lastTriggeredImage) : that.lastTriggeredImage != null);
    }

    public int hashCode() {
        return Objects.hash(this.automatic, this.containerNames, this.from, this.lastTriggeredImage, super.hashCode());
    }

    public class FromNestedImpl<N>
    extends ObjectReferenceFluentImpl<DeploymentTriggerImageChangeParamsFluent.FromNested<N>>
    implements DeploymentTriggerImageChangeParamsFluent.FromNested<N>,
    Nested<N> {
        private final ObjectReferenceBuilder builder;

        FromNestedImpl(ObjectReference item) {
            this.builder = new ObjectReferenceBuilder(this, item);
        }

        FromNestedImpl() {
            this.builder = new ObjectReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)DeploymentTriggerImageChangeParamsFluentImpl.this.withFrom(this.builder.build());
        }

        @Override
        public N endFrom() {
            return this.and();
        }
    }
}

