/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.kubernetes.api.model.v5_4.ListMeta;
import io.fabric8.openshift.api.model.v5_4.ClusterVersion;
import io.fabric8.openshift.api.model.v5_4.ClusterVersionBuilder;
import io.fabric8.openshift.api.model.v5_4.ClusterVersionFluentImpl;
import io.fabric8.openshift.api.model.v5_4.ClusterVersionList;
import io.fabric8.openshift.api.model.v5_4.ClusterVersionListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterVersionListFluentImpl<A extends ClusterVersionListFluent<A>>
extends BaseFluent<A>
implements ClusterVersionListFluent<A> {
    private String apiVersion;
    private List<ClusterVersionBuilder> items = new ArrayList<ClusterVersionBuilder>();
    private String kind;
    private ListMeta metadata;

    public ClusterVersionListFluentImpl() {
    }

    public ClusterVersionListFluentImpl(ClusterVersionList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToItems(int index, ClusterVersion item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterVersionBuilder>();
        }
        ClusterVersionBuilder builder = new ClusterVersionBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ClusterVersion item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterVersionBuilder>();
        }
        ClusterVersionBuilder builder = new ClusterVersionBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ClusterVersion ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterVersionBuilder>();
        }
        for (ClusterVersion item : items) {
            ClusterVersionBuilder builder = new ClusterVersionBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ClusterVersion> items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterVersionBuilder>();
        }
        for (ClusterVersion item : items) {
            ClusterVersionBuilder builder = new ClusterVersionBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ClusterVersion ... items) {
        for (ClusterVersion item : items) {
            ClusterVersionBuilder builder = new ClusterVersionBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ClusterVersion> items) {
        for (ClusterVersion item : items) {
            ClusterVersionBuilder builder = new ClusterVersionBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ClusterVersionBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ClusterVersionBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            ClusterVersionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterVersion> getItems() {
        return ClusterVersionListFluentImpl.build(this.items);
    }

    @Override
    public List<ClusterVersion> buildItems() {
        return ClusterVersionListFluentImpl.build(this.items);
    }

    @Override
    public ClusterVersion buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ClusterVersion buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ClusterVersion buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ClusterVersion buildMatchingItem(Predicate<ClusterVersionBuilder> predicate) {
        for (ClusterVersionBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ClusterVersionBuilder> predicate) {
        for (ClusterVersionBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ClusterVersion> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ClusterVersionBuilder>();
            for (ClusterVersion item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ClusterVersion ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ClusterVersion item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ClusterVersionListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ClusterVersionListFluent.ItemsNested<A> addNewItemLike(ClusterVersion item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ClusterVersionListFluent.ItemsNested<A> setNewItemLike(int index, ClusterVersion item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ClusterVersionListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterVersionListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ClusterVersionListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterVersionListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterVersionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterVersionListFluentImpl that = (ClusterVersionListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends ClusterVersionFluentImpl<ClusterVersionListFluent.ItemsNested<N>>
    implements ClusterVersionListFluent.ItemsNested<N>,
    Nested<N> {
        private final ClusterVersionBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ClusterVersion item) {
            this.index = index;
            this.builder = new ClusterVersionBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterVersionBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterVersionListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

