/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.openshift.api.model.v5_4.AWSPlatformStatus;
import io.fabric8.openshift.api.model.v5_4.AWSPlatformStatusFluent;
import io.fabric8.openshift.api.model.v5_4.AWSServiceEndpoint;
import io.fabric8.openshift.api.model.v5_4.AWSServiceEndpointBuilder;
import io.fabric8.openshift.api.model.v5_4.AWSServiceEndpointFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class AWSPlatformStatusFluentImpl<A extends AWSPlatformStatusFluent<A>>
extends BaseFluent<A>
implements AWSPlatformStatusFluent<A> {
    private String region;
    private List<AWSServiceEndpointBuilder> serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();

    public AWSPlatformStatusFluentImpl() {
    }

    public AWSPlatformStatusFluentImpl(AWSPlatformStatus instance) {
        this.withRegion(instance.getRegion());
        this.withServiceEndpoints(instance.getServiceEndpoints());
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public A withRegion(String region) {
        this.region = region;
        return (A)this;
    }

    @Override
    public Boolean hasRegion() {
        return this.region != null;
    }

    @Override
    @Deprecated
    public A withNewRegion(String arg0) {
        return this.withRegion(new String(arg0));
    }

    @Override
    public A addToServiceEndpoints(int index, AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
        }
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        this._visitables.get("serviceEndpoints").add(index >= 0 ? index : this._visitables.get("serviceEndpoints").size(), builder);
        this.serviceEndpoints.add(index >= 0 ? index : this.serviceEndpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToServiceEndpoints(int index, AWSServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
        }
        AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get("serviceEndpoints").size()) {
            this._visitables.get("serviceEndpoints").add(builder);
        } else {
            this._visitables.get("serviceEndpoints").set(index, builder);
        }
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this.serviceEndpoints.add(builder);
        } else {
            this.serviceEndpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToServiceEndpoints(AWSServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
        }
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceEndpoints(AWSServiceEndpoint ... items) {
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            if (this.serviceEndpoints == null) continue;
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceEndpoints(Collection<AWSServiceEndpoint> items) {
        for (AWSServiceEndpoint item : items) {
            AWSServiceEndpointBuilder builder = new AWSServiceEndpointBuilder(item);
            this._visitables.get("serviceEndpoints").remove(builder);
            if (this.serviceEndpoints == null) continue;
            this.serviceEndpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromServiceEndpoints(Predicate<AWSServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)this;
        }
        Iterator<AWSServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        Object visitables = this._visitables.get("serviceEndpoints");
        while (each.hasNext()) {
            AWSServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<AWSServiceEndpoint> getServiceEndpoints() {
        return AWSPlatformStatusFluentImpl.build(this.serviceEndpoints);
    }

    @Override
    public List<AWSServiceEndpoint> buildServiceEndpoints() {
        return AWSPlatformStatusFluentImpl.build(this.serviceEndpoints);
    }

    @Override
    public AWSServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    @Override
    public AWSServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    @Override
    public AWSServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    @Override
    public AWSServiceEndpoint buildMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        for (AWSServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceEndpoints(List<AWSServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get("serviceEndpoints").removeAll(this.serviceEndpoints);
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList<AWSServiceEndpointBuilder>();
            for (AWSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceEndpoints(AWSServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
        }
        if (serviceEndpoints != null) {
            for (AWSServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    @Override
    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new AWSServiceEndpoint(name, url));
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNestedImpl();
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> addNewServiceEndpointLike(AWSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(-1, item);
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, AWSServiceEndpoint item) {
        return new ServiceEndpointsNestedImpl(index, item);
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException("Can't edit serviceEndpoints. Index exceeds size.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException("Can't edit first serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last serviceEndpoints. The list is empty.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    @Override
    public AWSPlatformStatusFluent.ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<AWSServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching serviceEndpoints. No match found.");
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AWSPlatformStatusFluentImpl that = (AWSPlatformStatusFluentImpl)o;
        if (this.region != null ? !this.region.equals(that.region) : that.region != null) {
            return false;
        }
        return !(this.serviceEndpoints != null ? !this.serviceEndpoints.equals(that.serviceEndpoints) : that.serviceEndpoints != null);
    }

    public int hashCode() {
        return Objects.hash(this.region, this.serviceEndpoints, super.hashCode());
    }

    public class ServiceEndpointsNestedImpl<N>
    extends AWSServiceEndpointFluentImpl<AWSPlatformStatusFluent.ServiceEndpointsNested<N>>
    implements AWSPlatformStatusFluent.ServiceEndpointsNested<N>,
    Nested<N> {
        private final AWSServiceEndpointBuilder builder;
        private final int index;

        ServiceEndpointsNestedImpl(int index, AWSServiceEndpoint item) {
            this.index = index;
            this.builder = new AWSServiceEndpointBuilder(this, item);
        }

        ServiceEndpointsNestedImpl() {
            this.index = -1;
            this.builder = new AWSServiceEndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)AWSPlatformStatusFluentImpl.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endServiceEndpoint() {
            return this.and();
        }
    }
}

