/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.v5_4.AuthInfo;
import io.fabric8.kubernetes.api.model.v5_4.Cluster;
import io.fabric8.kubernetes.api.model.v5_4.Config;
import io.fabric8.kubernetes.api.model.v5_4.Context;
import io.fabric8.kubernetes.api.model.v5_4.NamedAuthInfo;
import io.fabric8.kubernetes.api.model.v5_4.NamedCluster;
import io.fabric8.kubernetes.api.model.v5_4.NamedContext;
import io.fabric8.kubernetes.clnt.v5_4.utils.Serialization;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class KubeConfigUtils {
    private KubeConfigUtils() {
    }

    public static Config parseConfig(File file) throws IOException {
        ObjectMapper mapper = Serialization.yamlMapper();
        return (Config)mapper.readValue(file, Config.class);
    }

    public static Config parseConfigFromString(String contents) throws IOException {
        ObjectMapper mapper = Serialization.yamlMapper();
        return (Config)mapper.readValue(contents, Config.class);
    }

    public static NamedContext getCurrentContext(Config config) {
        List<NamedContext> contexts;
        String contextName = config.getCurrentContext();
        if (contextName != null && (contexts = config.getContexts()) != null) {
            for (NamedContext context : contexts) {
                if (!contextName.equals(context.getName())) continue;
                return context;
            }
        }
        return null;
    }

    public static String getUserToken(Config config, Context context) {
        AuthInfo authInfo = KubeConfigUtils.getUserAuthInfo(config, context);
        if (authInfo != null) {
            return authInfo.getToken();
        }
        return null;
    }

    public static AuthInfo getUserAuthInfo(Config config, Context context) {
        List<NamedAuthInfo> users;
        String user;
        AuthInfo authInfo = null;
        if (config != null && context != null && (user = context.getUser()) != null && (users = config.getUsers()) != null) {
            authInfo = users.stream().filter(u -> u.getName().equals(user)).findAny().map(NamedAuthInfo::getUser).orElse(null);
        }
        return authInfo;
    }

    public static Cluster getCluster(Config config, Context context) {
        List<NamedCluster> clusters;
        String clusterName;
        Cluster cluster = null;
        if (config != null && context != null && (clusterName = context.getCluster()) != null && (clusters = config.getClusters()) != null) {
            cluster = clusters.stream().filter(c -> c.getName().equals(clusterName)).findAny().map(NamedCluster::getCluster).orElse(null);
        }
        return cluster;
    }

    public static int getNamedUserIndexFromConfig(Config config, String userName) {
        for (int i = 0; i < config.getUsers().size(); ++i) {
            if (!config.getUsers().get(i).getName().equals(userName)) continue;
            return i;
        }
        return -1;
    }

    public static void persistKubeConfigIntoFile(Config kubeConfig, String kubeConfigPath) throws IOException {
        Serialization.yamlMapper().writeValue(new File(kubeConfigPath), (Object)kubeConfig);
    }
}

