/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.informers.cache;

import io.fabric8.kubernetes.api.model.v5_4.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_4.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_4.Watcher;
import io.fabric8.kubernetes.clnt.v5_4.WatcherException;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.Store;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectorWatcher<T extends HasMetadata>
implements Watcher<T> {
    private static final Logger log = LoggerFactory.getLogger(ReflectorWatcher.class);
    private final Store<T> store;
    private final AtomicReference<String> lastSyncResourceVersion;
    private final Runnable onHttpGone;

    public ReflectorWatcher(Store<T> store, AtomicReference<String> lastSyncResourceVersion, Runnable onHttpGone) {
        this.store = store;
        this.lastSyncResourceVersion = lastSyncResourceVersion;
        this.onHttpGone = onHttpGone;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        if (action == null) {
            throw new KubernetesClientException("Unrecognized event");
        }
        if (resource == null) {
            throw new KubernetesClientException("Unrecognized resource");
        }
        if (log.isDebugEnabled()) {
            log.debug("Event received {} {}# resourceVersion {}", new Object[]{action.name(), resource.getKind(), resource.getMetadata().getResourceVersion()});
        }
        switch (action) {
            case ERROR: {
                throw new KubernetesClientException("ERROR event");
            }
            case ADDED: {
                this.store.add(resource);
                break;
            }
            case MODIFIED: {
                this.store.update(resource);
                break;
            }
            case DELETED: {
                this.store.delete(resource);
            }
        }
        this.lastSyncResourceVersion.set(resource.getMetadata().getResourceVersion());
    }

    @Override
    public void onClose(WatcherException exception) {
        log.warn("Watch closing with exception", (Throwable)exception);
        if (exception.isHttpGone()) {
            this.onHttpGone.run();
        }
    }

    @Override
    public void onClose() {
        log.debug("Watch gracefully closed");
    }

    @Override
    public boolean reconnecting() {
        return true;
    }
}

