/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v5_4.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_4.ListOptions;
import io.fabric8.kubernetes.api.model.v5_4.Secret;
import io.fabric8.kubernetes.api.model.v5_4.SecretBuilder;
import io.fabric8.kubernetes.clnt.v5_4.Config;
import io.fabric8.kubernetes.clnt.v5_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_4.Watch;
import io.fabric8.kubernetes.clnt.v5_4.Watcher;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_4.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_4.dsl.internal.core.v1.SecretOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class SecretHandler
implements ResourceHandler<Secret, SecretBuilder> {
    @Override
    public String getKind() {
        return Secret.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Secret create(OkHttpClient client, Config config, String namespace, Secret item, boolean dryRun) {
        return (Secret)((WritableOperation)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Secret[0]);
    }

    @Override
    public Secret replace(OkHttpClient client, Config config, String namespace, Secret item, boolean dryRun) {
        return ((WritableOperation)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Secret reload(OkHttpClient client, Config config, String namespace, Secret item) {
        return (Secret)((Gettable)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public SecretBuilder edit(Secret item) {
        return new SecretBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Secret item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new SecretOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Secret item, Watcher<Secret> watcher) {
        return ((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Secret item, String resourceVersion, Watcher<Secret> watcher) {
        return ((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Secret item, ListOptions options, Watcher<Secret> watcher) {
        return ((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Secret waitUntilReady(OkHttpClient client, Config config, String namespace, Secret item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Secret)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Secret waitUntilCondition(OkHttpClient client, Config config, String namespace, Secret item, Predicate<Secret> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Secret)((Resource)new SecretOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

