/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.handlers.apps.v1;

import io.fabric8.kubernetes.api.model.v5_4.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_4.ListOptions;
import io.fabric8.kubernetes.api.model.v5_4.apps.Deployment;
import io.fabric8.kubernetes.api.model.v5_4.apps.DeploymentBuilder;
import io.fabric8.kubernetes.clnt.v5_4.Config;
import io.fabric8.kubernetes.clnt.v5_4.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_4.Watch;
import io.fabric8.kubernetes.clnt.v5_4.Watcher;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_4.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_4.dsl.internal.apps.v1.DeploymentOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class DeploymentHandler
implements ResourceHandler<Deployment, DeploymentBuilder> {
    @Override
    public String getKind() {
        return Deployment.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "apps/v1";
    }

    @Override
    public Deployment create(OkHttpClient client, Config config, String namespace, Deployment item, boolean dryRun) {
        return (Deployment)((WritableOperation)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Deployment[0]);
    }

    @Override
    public Deployment replace(OkHttpClient client, Config config, String namespace, Deployment item, boolean dryRun) {
        return ((WritableOperation)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Deployment reload(OkHttpClient client, Config config, String namespace, Deployment item) {
        return (Deployment)((Gettable)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public DeploymentBuilder edit(Deployment item) {
        return new DeploymentBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Deployment item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new DeploymentOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Deployment item, Watcher<Deployment> watcher) {
        return ((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Deployment item, String resourceVersion, Watcher<Deployment> watcher) {
        return ((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Deployment item, ListOptions options, Watcher<Deployment> watcher) {
        return ((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Deployment waitUntilReady(OkHttpClient client, Config config, String namespace, Deployment item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Deployment)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Deployment waitUntilCondition(OkHttpClient client, Config config, String namespace, Deployment item, Predicate<Deployment> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Deployment)((RollableScalableResource)new DeploymentOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

