/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_4.PodDNSConfig;
import io.fabric8.kubernetes.api.model.v5_4.PodDNSConfigFluent;
import io.fabric8.kubernetes.api.model.v5_4.PodDNSConfigFluentImpl;
import java.util.Objects;

public class PodDNSConfigBuilder
extends PodDNSConfigFluentImpl<PodDNSConfigBuilder>
implements VisitableBuilder<PodDNSConfig, PodDNSConfigBuilder> {
    PodDNSConfigFluent<?> fluent;
    Boolean validationEnabled;

    public PodDNSConfigBuilder() {
        this(true);
    }

    public PodDNSConfigBuilder(Boolean validationEnabled) {
        this(new PodDNSConfig(), validationEnabled);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new PodDNSConfig(), validationEnabled);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent, PodDNSConfig instance) {
        this(fluent, instance, true);
    }

    public PodDNSConfigBuilder(PodDNSConfigFluent<?> fluent, PodDNSConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withNameservers(instance.getNameservers());
        fluent.withOptions(instance.getOptions());
        fluent.withSearches(instance.getSearches());
        this.validationEnabled = validationEnabled;
    }

    public PodDNSConfigBuilder(PodDNSConfig instance) {
        this(instance, (Boolean)true);
    }

    public PodDNSConfigBuilder(PodDNSConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withNameservers(instance.getNameservers());
        this.withOptions(instance.getOptions());
        this.withSearches(instance.getSearches());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public PodDNSConfig build() {
        PodDNSConfig buildable = new PodDNSConfig(this.fluent.getNameservers(), this.fluent.getOptions(), this.fluent.getSearches());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PodDNSConfigBuilder that = (PodDNSConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

