/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_4.internal;

import com.fasterxml.jackson.databind.JsonNode;
import io.fabric8.kubernetes.clnt.v5_4.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_4.utils.Serialization;
import io.fabric8.kubernetes.clnt.v5_4.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_4.utils.Utils;
import io.fabric8.openshift.clnt.v5_4.OpenShiftConfig;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;

public class OpenShiftOAuthInterceptor
implements Interceptor {
    private static final String AUTHORIZATION = "Authorization";
    private static final String LOCATION = "Location";
    private static final String AUTHORIZATION_SERVER_PATH = ".well-known/oauth-authorization-server";
    private static final String AUTHORIZE_QUERY = "?response_type=token&client_id=openshift-challenging-client";
    private static final String BEFORE_TOKEN = "access_token=";
    private static final String AFTER_TOKEN = "&expires";
    private static final String K8S_AUTHORIZATION = "authorization.k8s.io";
    private static final String OPENSHIFT_AUTHORIZATION = "authorization.openshift.io";
    private final OkHttpClient client;
    private final OpenShiftConfig config;
    private final AtomicReference<String> oauthToken = new AtomicReference();

    public OpenShiftOAuthInterceptor(OkHttpClient client, OpenShiftConfig config) {
        this.client = client;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        Request request = chain.request();
        Request.Builder builder = request.newBuilder();
        String token = this.oauthToken.get();
        if (Utils.isNotNullOrEmpty(token) && Utils.isNullOrEmpty(request.header(AUTHORIZATION))) {
            this.setAuthHeader(builder, token);
        }
        if (this.isResponseSuccessful(request = builder.build(), response = chain.proceed(request))) {
            return response;
        }
        if (Utils.isNotNullOrEmpty(this.config.getUsername()) && Utils.isNotNullOrEmpty(this.config.getPassword())) {
            OkHttpClient okHttpClient = this.client;
            synchronized (okHttpClient) {
                this.oauthToken.set(null);
                token = this.authorize();
                if (token != null) {
                    this.oauthToken.set(token);
                }
            }
        } else if (Utils.isNotNullOrEmpty(this.config.getOauthToken())) {
            token = this.config.getOauthToken();
            this.oauthToken.set(token);
        }
        if (Utils.isNotNullOrEmpty(token)) {
            response.body().close();
            this.setAuthHeader(builder, token);
            request = builder.build();
            return chain.proceed(request);
        }
        return response;
    }

    private void setAuthHeader(Request.Builder builder, String token) {
        if (token != null) {
            builder.header(AUTHORIZATION, String.format("Bearer %s", token));
        }
    }

    private String authorize() {
        try {
            OkHttpClient.Builder builder = this.client.newBuilder();
            builder.interceptors().remove(this);
            OkHttpClient clone = builder.build();
            URL url = new URL(URLUtils.join(this.config.getMasterUrl(), AUTHORIZATION_SERVER_PATH));
            Response response = clone.newCall(new Request.Builder().get().url(url).build()).execute();
            if (!response.isSuccessful() || response.body() == null) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + ")");
            }
            String body = response.body().string();
            JsonNode jsonResponse = Serialization.jsonMapper().readTree(body);
            String authorizationServer = jsonResponse.get("authorization_endpoint").asText();
            response.close();
            url = new URL(authorizationServer + AUTHORIZE_QUERY);
            String credential = Credentials.basic((String)this.config.getUsername(), (String)this.config.getPassword());
            response = clone.newCall(new Request.Builder().get().url(url).header(AUTHORIZATION, credential).build()).execute();
            response.close();
            response = response.priorResponse() != null ? response.priorResponse() : response;
            response = response.networkResponse() != null ? response.networkResponse() : response;
            String token = response.header(LOCATION);
            if (token == null || token.isEmpty()) {
                throw new KubernetesClientException("Unexpected response (" + response.code() + " " + response.message() + "), to the authorization request. Missing header:[" + LOCATION + "]!");
            }
            token = token.substring(token.indexOf(BEFORE_TOKEN) + BEFORE_TOKEN.length());
            token = token.substring(0, token.indexOf(AFTER_TOKEN));
            return token;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private boolean isResponseSuccessful(Request request, Response response) {
        String url = request.url().toString();
        if (url.contains(K8S_AUTHORIZATION) || url.contains(OPENSHIFT_AUTHORIZATION)) {
            return false;
        }
        return response.code() != 401 && response.code() != 403;
    }
}

