/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_4.dsl.internal.apps;

import io.fabric8.kubernetes.api.builder.v5_4.Visitor;
import io.fabric8.kubernetes.api.model.v5_4.Pod;
import io.fabric8.kubernetes.api.model.v5_4.autoscaling.v1.Scale;
import io.fabric8.kubernetes.clnt.v5_4.Config;
import io.fabric8.kubernetes.clnt.v5_4.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_4.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_4.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_4.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.clnt.v5_4.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v5_4.utils.PodOperationUtil;
import io.fabric8.kubernetes.clnt.v5_4.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_4.utils.Utils;
import io.fabric8.openshift.api.model.v5_4.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_4.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.v5_4.DeploymentConfigList;
import io.fabric8.openshift.clnt.v5_4.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v5_4.dsl.internal.OpenShiftOperation;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentConfigOperationsImpl
extends OpenShiftOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>>
implements DeployableScalableResource<DeploymentConfig> {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentConfigOperationsImpl.class);
    private static final Integer DEFAULT_POD_LOG_WAIT_TIMEOUT = 5;
    public static final String OPENSHIFT_IO_DEPLOYMENT_CONFIG_NAME = "openshift.io/deployment-config.name";
    private Integer podLogWaitTimeout;

    public DeploymentConfigOperationsImpl(OkHttpClient client, Config config) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
    }

    public DeploymentConfigOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps.openshift.io").withPlural("deploymentconfigs"));
        this.type = DeploymentConfig.class;
        this.listType = DeploymentConfigList.class;
    }

    private DeploymentConfigOperationsImpl(RollingOperationContext context, Integer podLogWaitTimeout) {
        this(context);
        this.podLogWaitTimeout = podLogWaitTimeout;
    }

    public DeploymentConfigOperationsImpl newInstance(OperationContext context) {
        return new DeploymentConfigOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public DeploymentConfig edit(UnaryOperator<DeploymentConfig> function) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).edit(function);
        }
        return (DeploymentConfig)super.edit((UnaryOperator)function);
    }

    @Override
    public DeploymentConfig accept(Consumer<DeploymentConfig> consumer) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).accept(consumer);
        }
        return (DeploymentConfig)super.accept((Consumer)consumer);
    }

    @Override
    public DeploymentConfig replace(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public DeploymentConfig patch(DeploymentConfig item) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).patch(item);
        }
        return super.patch(item);
    }

    @Override
    public DeploymentConfig deployLatest() {
        return this.deployLatest(false);
    }

    @Override
    public DeploymentConfig deployLatest(boolean wait) {
        Long currentVersion = ((DeploymentConfig)this.getMandatory()).getStatus().getLatestVersion();
        if (currentVersion == null) {
            currentVersion = 1L;
        }
        Long latestVersion = currentVersion + 1L;
        DeploymentConfig deployment = this.cascading(false).accept((T d) -> d.getStatus().setLatestVersion(latestVersion));
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(deployment.getSpec().getReplicas());
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    @Override
    public DeploymentConfig scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public DeploymentConfig scale(int count, boolean wait) {
        DeploymentConfig deployment = this.cascading(false).accept((T d) -> d.getSpec().setReplicas(count));
        if (wait) {
            this.waitUntilDeploymentConfigIsScaled(count);
            deployment = (DeploymentConfig)this.getMandatory();
        }
        return deployment;
    }

    @Override
    public Scale scale() {
        return this.handleScale(null);
    }

    @Override
    public Scale scale(Scale scale) {
        return this.handleScale(scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeploymentConfigIsScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable deploymentPoller = () -> {
            try {
                int currentReplicas;
                DeploymentConfig deploymentConfig = (DeploymentConfig)this.get();
                if (deploymentConfig == null) {
                    if (count == 0) {
                        queue.put(true);
                        return;
                    }
                    queue.put(new IllegalStateException("Can't wait for DeploymentConfig: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available."));
                    return;
                }
                replicasRef.set(deploymentConfig.getStatus().getReplicas());
                int n = currentReplicas = deploymentConfig.getStatus().getReplicas() != null ? deploymentConfig.getStatus().getReplicas() : 0;
                if (deploymentConfig.getStatus().getObservedGeneration() >= deploymentConfig.getMetadata().getGeneration() && Objects.equals(deploymentConfig.getSpec().getReplicas(), currentReplicas)) {
                    queue.put(true);
                } else {
                    LOG.debug("Only {}/{} pods scheduled for DeploymentConfig: {} in namespace: {} seconds so waiting...", new Object[]{deploymentConfig.getStatus().getReplicas(), deploymentConfig.getSpec().getReplicas(), deploymentConfig.getMetadata().getName(), namespace});
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Deployment to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.debug("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for DeploymentConfig: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getLog(Boolean isPretty) {
        try (ResponseBody body = this.doGetLog(isPretty);){
            String string = this.doGetLog(isPretty).string();
            return string;
        }
        catch (IOException e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("getLog"), (Throwable)e);
        }
    }

    private ResponseBody doGetLog(Boolean isPretty) {
        try {
            Request.Builder requestBuilder = new Request.Builder().get().url(this.getResourceLogUrl(isPretty, false));
            Request request = requestBuilder.build();
            Response response = this.client.newCall(request).execute();
            ResponseBody body = response.body();
            this.assertResponseCode(request, response);
            return body;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("doGetLog"), t);
        }
    }

    @Override
    public Reader getLogReader() {
        return this.doGetLog(false).charStream();
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        try {
            this.waitUntilDeploymentConfigPodBecomesReady((DeploymentConfig)this.fromServer().get());
            Request request = new Request.Builder().url(this.getResourceLogUrl(false, true)).get().build();
            LogWatchCallback callback = new LogWatchCallback(out);
            OkHttpClient clone = this.client.newBuilder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
            clone.newCall(request).enqueue((Callback)callback);
            callback.waitUntilReady();
            return callback;
        }
        catch (Throwable t) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watchLog"), t);
        }
    }

    private HttpUrl getResourceLogUrl(Boolean withPrettyOutput, Boolean follow) throws MalformedURLException {
        HttpUrl.Builder requestUrlBuilder = HttpUrl.get((String)URLUtils.join(this.getResourceUrl().toString(), "log")).newBuilder();
        if (Boolean.TRUE.equals(withPrettyOutput)) {
            requestUrlBuilder.addQueryParameter("pretty", withPrettyOutput.toString());
        }
        if (Boolean.TRUE.equals(follow)) {
            requestUrlBuilder.addQueryParameter("follow", "true");
        }
        return requestUrlBuilder.build();
    }

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new DeploymentConfigOperationsImpl((RollingOperationContext)this.context, this.podLogWaitTimeout);
    }

    @Override
    public DeploymentConfig edit(Visitor ... visitors) {
        return this.patch(((DeploymentConfigBuilder)new DeploymentConfigBuilder((DeploymentConfig)this.getMandatory()).accept(visitors)).build());
    }

    private void waitUntilDeploymentConfigPodBecomesReady(DeploymentConfig deploymentConfig) {
        List<PodResource<Pod>> podOps = PodOperationUtil.getPodOperationsForController(this.context, deploymentConfig.getMetadata().getUid(), DeploymentConfigOperationsImpl.getDeploymentConfigPodLabels(deploymentConfig), false, this.podLogWaitTimeout);
        DeploymentConfigOperationsImpl.waitForBuildPodToBecomeReady(podOps, this.podLogWaitTimeout != null ? this.podLogWaitTimeout : DEFAULT_POD_LOG_WAIT_TIMEOUT);
    }

    private static void waitForBuildPodToBecomeReady(List<PodResource<Pod>> podOps, Integer podLogWaitTimeout) {
        for (PodResource<Pod> podOp : podOps) {
            PodOperationUtil.waitUntilReadyBeforeFetchingLogs(podOp, podLogWaitTimeout);
        }
    }

    static Map<String, String> getDeploymentConfigPodLabels(DeploymentConfig deploymentConfig) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (deploymentConfig != null && deploymentConfig.getMetadata() != null) {
            labels.put(OPENSHIFT_IO_DEPLOYMENT_CONFIG_NAME, deploymentConfig.getMetadata().getName());
        }
        return labels;
    }
}

