/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_4.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_4.operator.v1.ProxyConfig;
import io.fabric8.openshift.api.model.v5_4.operator.v1.ProxyConfigFluent;
import io.fabric8.openshift.api.model.v5_4.operator.v1.ProxyConfigFluentImpl;
import java.util.Objects;

public class ProxyConfigBuilder
extends ProxyConfigFluentImpl<ProxyConfigBuilder>
implements VisitableBuilder<ProxyConfig, ProxyConfigBuilder> {
    ProxyConfigFluent<?> fluent;
    Boolean validationEnabled;

    public ProxyConfigBuilder() {
        this(true);
    }

    public ProxyConfigBuilder(Boolean validationEnabled) {
        this(new ProxyConfig(), validationEnabled);
    }

    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ProxyConfig(), validationEnabled);
    }

    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent, ProxyConfig instance) {
        this(fluent, instance, true);
    }

    public ProxyConfigBuilder(ProxyConfigFluent<?> fluent, ProxyConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBindAddress(instance.getBindAddress());
        fluent.withIptablesSyncPeriod(instance.getIptablesSyncPeriod());
        fluent.withProxyArguments(instance.getProxyArguments());
        this.validationEnabled = validationEnabled;
    }

    public ProxyConfigBuilder(ProxyConfig instance) {
        this(instance, (Boolean)true);
    }

    public ProxyConfigBuilder(ProxyConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBindAddress(instance.getBindAddress());
        this.withIptablesSyncPeriod(instance.getIptablesSyncPeriod());
        this.withProxyArguments(instance.getProxyArguments());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ProxyConfig build() {
        ProxyConfig buildable = new ProxyConfig(this.fluent.getBindAddress(), this.fluent.getIptablesSyncPeriod(), this.fluent.getProxyArguments());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProxyConfigBuilder that = (ProxyConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

