/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_4.Nested;
import io.fabric8.kubernetes.api.model.v5_4.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_4.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_4.ObjectMetaFluentImpl;
import io.fabric8.openshift.api.model.v5_4.ImageStream;
import io.fabric8.openshift.api.model.v5_4.ImageStreamFluent;
import io.fabric8.openshift.api.model.v5_4.ImageStreamSpec;
import io.fabric8.openshift.api.model.v5_4.ImageStreamSpecBuilder;
import io.fabric8.openshift.api.model.v5_4.ImageStreamSpecFluentImpl;
import io.fabric8.openshift.api.model.v5_4.ImageStreamStatus;
import io.fabric8.openshift.api.model.v5_4.ImageStreamStatusBuilder;
import io.fabric8.openshift.api.model.v5_4.ImageStreamStatusFluentImpl;
import java.util.Objects;

public class ImageStreamFluentImpl<A extends ImageStreamFluent<A>>
extends BaseFluent<A>
implements ImageStreamFluent<A> {
    private String apiVersion;
    private String kind;
    private ObjectMetaBuilder metadata;
    private ImageStreamSpecBuilder spec;
    private ImageStreamStatusBuilder status;

    public ImageStreamFluentImpl() {
    }

    public ImageStreamFluentImpl(ImageStream instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public ImageStreamFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public ImageStreamFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public ImageStreamFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public ImageStreamFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public ImageStreamFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    @Deprecated
    public ImageStreamSpec getSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public ImageStreamSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    @Override
    public A withSpec(ImageStreamSpec spec) {
        this._visitables.get("spec").remove(this.spec);
        if (spec != null) {
            this.spec = new ImageStreamSpecBuilder(spec);
            this._visitables.get("spec").add(this.spec);
        }
        return (A)this;
    }

    @Override
    public Boolean hasSpec() {
        return this.spec != null;
    }

    @Override
    public ImageStreamFluent.SpecNested<A> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public ImageStreamFluent.SpecNested<A> withNewSpecLike(ImageStreamSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public ImageStreamFluent.SpecNested<A> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public ImageStreamFluent.SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : new ImageStreamSpecBuilder().build());
    }

    @Override
    public ImageStreamFluent.SpecNested<A> editOrNewSpecLike(ImageStreamSpec item) {
        return this.withNewSpecLike(this.getSpec() != null ? this.getSpec() : item);
    }

    @Override
    @Deprecated
    public ImageStreamStatus getStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public ImageStreamStatus buildStatus() {
        return this.status != null ? this.status.build() : null;
    }

    @Override
    public A withStatus(ImageStreamStatus status) {
        this._visitables.get("status").remove(this.status);
        if (status != null) {
            this.status = new ImageStreamStatusBuilder(status);
            this._visitables.get("status").add(this.status);
        }
        return (A)this;
    }

    @Override
    public Boolean hasStatus() {
        return this.status != null;
    }

    @Override
    public ImageStreamFluent.StatusNested<A> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public ImageStreamFluent.StatusNested<A> withNewStatusLike(ImageStreamStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public ImageStreamFluent.StatusNested<A> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public ImageStreamFluent.StatusNested<A> editOrNewStatus() {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : new ImageStreamStatusBuilder().build());
    }

    @Override
    public ImageStreamFluent.StatusNested<A> editOrNewStatusLike(ImageStreamStatus item) {
        return this.withNewStatusLike(this.getStatus() != null ? this.getStatus() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageStreamFluentImpl that = (ImageStreamFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals(that.status) : that.status != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.kind, this.metadata, this.spec, this.status, super.hashCode());
    }

    public class StatusNestedImpl<N>
    extends ImageStreamStatusFluentImpl<ImageStreamFluent.StatusNested<N>>
    implements ImageStreamFluent.StatusNested<N>,
    Nested<N> {
        private final ImageStreamStatusBuilder builder;

        StatusNestedImpl(ImageStreamStatus item) {
            this.builder = new ImageStreamStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new ImageStreamStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends ImageStreamSpecFluentImpl<ImageStreamFluent.SpecNested<N>>
    implements ImageStreamFluent.SpecNested<N>,
    Nested<N> {
        private final ImageStreamSpecBuilder builder;

        SpecNestedImpl(ImageStreamSpec item) {
            this.builder = new ImageStreamSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new ImageStreamSpecBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamFluentImpl.this.withSpec(this.builder.build());
        }

        @Override
        public N endSpec() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<ImageStreamFluent.MetadataNested<N>>
    implements ImageStreamFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)ImageStreamFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

