/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.informers.impl;

import io.fabric8.kubernetes.api.model.v5_4.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_4.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_4.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_4.informers.ListerWatcher;
import io.fabric8.kubernetes.clnt.v5_4.informers.ResourceEventHandler;
import io.fabric8.kubernetes.clnt.v5_4.informers.SharedIndexInformer;
import io.fabric8.kubernetes.clnt.v5_4.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.Cache;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.Controller;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.Indexer;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.ProcessorStore;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.SharedProcessor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedIndexInformer<T extends HasMetadata, L extends KubernetesResourceList<T>>
implements SharedIndexInformer<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedIndexInformer.class);
    private static final long MINIMUM_RESYNC_PERIOD_MILLIS = 1000L;
    private long resyncCheckPeriodMillis;
    private long defaultEventHandlerResyncPeriod;
    private Cache<T> indexer;
    private SharedProcessor<T> processor;
    private Controller<T, L> controller;
    private Thread controllerThread;
    private volatile boolean started = false;
    private volatile boolean stopped = false;

    public DefaultSharedIndexInformer(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, long resyncPeriod, OperationContext context, ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners) {
        this.resyncCheckPeriodMillis = resyncPeriod;
        this.defaultEventHandlerResyncPeriod = resyncPeriod;
        this.processor = new SharedProcessor();
        this.indexer = new Cache();
        this.indexer.setIsRunning(this::isRunning);
        ProcessorStore<T> processorStore = new ProcessorStore<T>(this.indexer, this.processor);
        this.controller = new Controller<T, L>(apiTypeClass, processorStore, listerWatcher, this.processor::shouldResync, this.resyncCheckPeriodMillis, context, eventListeners);
        this.controllerThread = new Thread(this.controller::run, "informer-controller-" + apiTypeClass.getSimpleName());
    }

    @Override
    public void addEventHandler(ResourceEventHandler<T> handler) {
        this.addEventHandlerWithResyncPeriod(handler, this.defaultEventHandlerResyncPeriod);
    }

    @Override
    public void addEventHandlerWithResyncPeriod(ResourceEventHandler<T> handler, long resyncPeriodMillis) {
        if (this.stopped) {
            log.info("DefaultSharedIndexInformer#Handler was not added to shared informer because it has stopped already");
            return;
        }
        if (resyncPeriodMillis > 0L) {
            if (resyncPeriodMillis < 1000L) {
                log.warn("DefaultSharedIndexInformer#resyncPeriod {} is too small. Changing it to minimal allowed value of {}", (Object)resyncPeriodMillis, (Object)1000L);
                resyncPeriodMillis = 1000L;
            }
            if (resyncPeriodMillis < this.resyncCheckPeriodMillis) {
                if (this.started) {
                    log.warn("DefaultSharedIndexInformer#resyncPeriod {} is smaller than resyncCheckPeriod {} and the informer has already started. Changing it to {}", (Object)resyncPeriodMillis, (Object)this.resyncCheckPeriodMillis);
                    resyncPeriodMillis = this.resyncCheckPeriodMillis;
                } else {
                    this.resyncCheckPeriodMillis = resyncPeriodMillis;
                }
            }
        }
        ProcessorListener<T> listener = new ProcessorListener<T>(handler, this.determineResyncPeriod(resyncPeriodMillis, this.resyncCheckPeriodMillis));
        if (!this.started) {
            this.processor.addListener(listener);
            return;
        }
        this.processor.addAndStartListener(listener);
        List<T> objectList = this.indexer.list();
        for (T item : objectList) {
            listener.add(new ProcessorListener.AddNotification<T>(item));
        }
    }

    @Override
    public String lastSyncResourceVersion() {
        return this.controller.lastSyncResourceVersion();
    }

    @Override
    public void run() {
        if (this.stopped) {
            throw new IllegalStateException("Cannot restart a stopped informer");
        }
        if (this.started) {
            return;
        }
        this.started = true;
        this.processor.run();
        this.controllerThread.start();
    }

    @Override
    public void stop() {
        if (!this.started || this.stopped) {
            return;
        }
        this.stopped = true;
        this.controller.stop();
        this.controllerThread.interrupt();
        this.processor.stop();
    }

    @Override
    public boolean hasSynced() {
        return this.controller != null && this.controller.hasSynced();
    }

    @Override
    public void addIndexers(Map<String, Function<T, List<String>>> indexers) {
        this.indexer.addIndexers(indexers);
    }

    @Override
    public Indexer getIndexer() {
        return this.indexer;
    }

    private long determineResyncPeriod(long desired, long check) {
        if (desired == 0L) {
            return desired;
        }
        if (check == 0L) {
            return 0L;
        }
        return desired < check ? check : desired;
    }

    @Override
    public boolean isRunning() {
        return !this.stopped && this.started && this.controller.isRunning();
    }
}

