/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.informers.cache;

import io.fabric8.kubernetes.clnt.v5_4.informers.cache.Cache;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.SharedProcessor;
import io.fabric8.kubernetes.clnt.v5_4.informers.cache.Store;
import java.util.HashMap;
import java.util.List;

public class ProcessorStore<T>
implements Store<T> {
    private Store<T> actualStore;
    private SharedProcessor<T> processor;
    private volatile boolean populated;

    public ProcessorStore(Store<T> actualStore, SharedProcessor<T> processor) {
        this.actualStore = actualStore;
        this.processor = processor;
    }

    @Override
    public void add(T obj) {
        this.update(obj);
    }

    @Override
    public synchronized void update(T obj) {
        Object oldObj = this.actualStore.get(obj);
        if (oldObj != null) {
            this.actualStore.update(obj);
            this.processor.distribute(new ProcessorListener.UpdateNotification<Object>(oldObj, obj), false);
        } else {
            this.actualStore.add(obj);
            this.processor.distribute(new ProcessorListener.AddNotification<T>(obj), false);
        }
    }

    @Override
    public synchronized void delete(T obj) {
        Object oldObj = this.actualStore.get(obj);
        if (oldObj != null) {
            this.actualStore.delete(obj);
            this.processor.distribute(new ProcessorListener.DeleteNotification<T>(obj, false), false);
        }
    }

    @Override
    public List<T> list() {
        return this.actualStore.list();
    }

    @Override
    public List<String> listKeys() {
        return this.actualStore.listKeys();
    }

    @Override
    public Object get(T object) {
        return this.actualStore.get(object);
    }

    @Override
    public T getByKey(String key) {
        return this.actualStore.getByKey(key);
    }

    @Override
    public synchronized void replace(List<T> list, String resourceVersion) {
        HashMap oldState = new HashMap();
        this.actualStore.list().stream().forEach(old -> oldState.put(Cache.metaNamespaceKeyFunc(old), old));
        this.actualStore.replace(list, resourceVersion);
        this.populated = true;
        for (T newValue : list) {
            Object old2 = oldState.remove(Cache.metaNamespaceKeyFunc(newValue));
            if (old2 == null) {
                this.processor.distribute(new ProcessorListener.AddNotification<T>(newValue), true);
                continue;
            }
            this.processor.distribute(new ProcessorListener.UpdateNotification(old2, newValue), true);
        }
        oldState.values().forEach(old -> this.processor.distribute(new ProcessorListener.DeleteNotification<Object>(old, true), false));
    }

    @Override
    public void resync() {
        this.actualStore.list().forEach(i -> this.processor.distribute(new ProcessorListener.UpdateNotification<Object>(i, i), true));
    }

    @Override
    public void isPopulated(boolean isPopulated) {
        this.populated = isPopulated;
    }

    @Override
    public boolean hasSynced() {
        return this.populated;
    }
}

