/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_4.extended.leaderelection.resourcelock;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.fabric8.kubernetes.api.model.v5_4.ConfigMap;
import io.fabric8.kubernetes.api.model.v5_4.ConfigMapBuilder;
import io.fabric8.kubernetes.api.model.v5_4.ConfigMapFluent;
import io.fabric8.kubernetes.api.model.v5_4.ObjectMeta;
import io.fabric8.kubernetes.clnt.v5_4.KubernetesClient;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Namespaceable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Replaceable;
import io.fabric8.kubernetes.clnt.v5_4.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_4.extended.leaderelection.resourcelock.LeaderElectionRecord;
import io.fabric8.kubernetes.clnt.v5_4.extended.leaderelection.resourcelock.Lock;
import io.fabric8.kubernetes.clnt.v5_4.extended.leaderelection.resourcelock.LockException;
import io.fabric8.kubernetes.clnt.v5_4.utils.Serialization;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapLock
implements Lock {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigMapLock.class);
    private final String configMapNamespace;
    private final String configMapName;
    private final String identity;
    private final ObjectMapper objectMapper;

    public ConfigMapLock(String configMapNamespace, String configMapName, String identity) {
        this.configMapNamespace = Objects.requireNonNull(configMapNamespace, "configMapNamespace is required");
        this.configMapName = Objects.requireNonNull(configMapName, "configMapName is required");
        this.identity = Objects.requireNonNull(identity, "identity is required");
        this.objectMapper = Serialization.jsonMapper();
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> LeaderElectionRecord get(C client) {
        ConfigMap configMap = (ConfigMap)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).get();
        return Optional.ofNullable(configMap).map(ConfigMap::getMetadata).map(ObjectMeta::getAnnotations).map(annotations -> (String)annotations.get("control-plane.alpha.kubernetes.io/leader")).map(annotation -> {
            try {
                return (LeaderElectionRecord)this.objectMapper.readValue(annotation, (TypeReference)new TypeReference<LeaderElectionRecord>(){});
            }
            catch (JsonProcessingException ex) {
                LOGGER.error("Error deserializing LeaderElectionRecord from ConfigMap", (Throwable)ex);
                return null;
            }
        }).map(record -> {
            record.setVersion((Serializable)((Object)configMap.getMetadata().getResourceVersion()));
            return record;
        }).orElse(null);
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> void create(C client, LeaderElectionRecord leaderElectionRecord) throws LockException {
        try {
            ((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).create(((ConfigMapBuilder)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)((ConfigMapFluent.MetadataNested)new ConfigMapBuilder().editOrNewMetadata().withNamespace(this.configMapNamespace)).withName(this.configMapName)).addToAnnotations("control-plane.alpha.kubernetes.io/leader", this.objectMapper.writeValueAsString((Object)leaderElectionRecord))).endMetadata()).build());
        }
        catch (Exception e) {
            throw new LockException("Unable to create ConfigMapLock", e);
        }
    }

    @Override
    public <C extends Namespaceable<C> & KubernetesClient> void update(C client, LeaderElectionRecord leaderElectionRecord) throws LockException {
        try {
            ConfigMap toReplace = (ConfigMap)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).get();
            toReplace.getMetadata().getAnnotations().put("control-plane.alpha.kubernetes.io/leader", this.objectMapper.writeValueAsString((Object)leaderElectionRecord));
            ((Replaceable)((Resource)((KubernetesClient)((Object)((Namespaceable)client.inNamespace(this.configMapNamespace)))).configMaps().withName(this.configMapName)).lockResourceVersion((String)((Object)Objects.requireNonNull(leaderElectionRecord.getVersion())))).replace(toReplace);
        }
        catch (Exception e) {
            throw new LockException("Unable to update ConfigMapLock", e);
        }
    }

    @Override
    public String identity() {
        return this.identity;
    }

    @Override
    public String describe() {
        return String.format("ConfigMapLock: %s - %s (%s)", this.configMapNamespace, this.configMapName, this.identity);
    }
}

