/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_4.Taint;
import io.fabric8.kubernetes.api.model.v5_4.TaintFluent;
import io.fabric8.kubernetes.api.model.v5_4.TaintFluentImpl;
import java.util.Objects;

public class TaintBuilder
extends TaintFluentImpl<TaintBuilder>
implements VisitableBuilder<Taint, TaintBuilder> {
    TaintFluent<?> fluent;
    Boolean validationEnabled;

    public TaintBuilder() {
        this(true);
    }

    public TaintBuilder(Boolean validationEnabled) {
        this(new Taint(), validationEnabled);
    }

    public TaintBuilder(TaintFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public TaintBuilder(TaintFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Taint(), validationEnabled);
    }

    public TaintBuilder(TaintFluent<?> fluent, Taint instance) {
        this(fluent, instance, true);
    }

    public TaintBuilder(TaintFluent<?> fluent, Taint instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withEffect(instance.getEffect());
        fluent.withKey(instance.getKey());
        fluent.withTimeAdded(instance.getTimeAdded());
        fluent.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    public TaintBuilder(Taint instance) {
        this(instance, (Boolean)true);
    }

    public TaintBuilder(Taint instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withEffect(instance.getEffect());
        this.withKey(instance.getKey());
        this.withTimeAdded(instance.getTimeAdded());
        this.withValue(instance.getValue());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public Taint build() {
        Taint buildable = new Taint(this.fluent.getEffect(), this.fluent.getKey(), this.fluent.getTimeAdded(), this.fluent.getValue());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaintBuilder that = (TaintBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

