/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_4;

import io.fabric8.kubernetes.api.builder.v5_4.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_4.PodExecOptions;
import io.fabric8.kubernetes.api.model.v5_4.PodExecOptionsFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class PodExecOptionsFluentImpl<A extends PodExecOptionsFluent<A>>
extends BaseFluent<A>
implements PodExecOptionsFluent<A> {
    private String apiVersion;
    private List<String> command = new ArrayList<String>();
    private String container;
    private String kind;
    private Boolean stderr;
    private Boolean stdin;
    private Boolean stdout;
    private Boolean tty;

    public PodExecOptionsFluentImpl() {
    }

    public PodExecOptionsFluentImpl(PodExecOptions instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withCommand(instance.getCommand());
        this.withContainer(instance.getContainer());
        this.withKind(instance.getKind());
        this.withStderr(instance.getStderr());
        this.withStdin(instance.getStdin());
        this.withStdout(instance.getStdout());
        this.withTty(instance.getTty());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    @Deprecated
    public A withNewApiVersion(String arg0) {
        return this.withApiVersion(new String(arg0));
    }

    @Override
    public A addToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.add(index, item);
        return (A)this;
    }

    @Override
    public A setToCommand(int index, String item) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.set(index, item);
        return (A)this;
    }

    @Override
    public A addToCommand(String ... items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToCommand(Collection<String> items) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        for (String item : items) {
            this.command.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromCommand(String ... items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromCommand(Collection<String> items) {
        for (String item : items) {
            if (this.command == null) continue;
            this.command.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getCommand() {
        return this.command;
    }

    @Override
    public String getCommand(int index) {
        return this.command.get(index);
    }

    @Override
    public String getFirstCommand() {
        return this.command.get(0);
    }

    @Override
    public String getLastCommand() {
        return this.command.get(this.command.size() - 1);
    }

    @Override
    public String getMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCommand(Predicate<String> predicate) {
        for (String item : this.command) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withCommand(List<String> command) {
        if (this.command != null) {
            this._visitables.get("command").removeAll(this.command);
        }
        if (command != null) {
            this.command = new ArrayList<String>();
            for (String item : command) {
                this.addToCommand(item);
            }
        } else {
            this.command = null;
        }
        return (A)this;
    }

    @Override
    public A withCommand(String ... command) {
        if (this.command != null) {
            this.command.clear();
        }
        if (command != null) {
            for (String item : command) {
                this.addToCommand(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasCommand() {
        return this.command != null && !this.command.isEmpty();
    }

    @Override
    public A addNewCommand(String arg0) {
        return this.addToCommand(new String(arg0));
    }

    @Override
    public String getContainer() {
        return this.container;
    }

    @Override
    public A withContainer(String container) {
        this.container = container;
        return (A)this;
    }

    @Override
    public Boolean hasContainer() {
        return this.container != null;
    }

    @Override
    @Deprecated
    public A withNewContainer(String arg0) {
        return this.withContainer(new String(arg0));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    @Deprecated
    public A withNewKind(String arg0) {
        return this.withKind(new String(arg0));
    }

    @Override
    public Boolean getStderr() {
        return this.stderr;
    }

    @Override
    public A withStderr(Boolean stderr) {
        this.stderr = stderr;
        return (A)this;
    }

    @Override
    public Boolean hasStderr() {
        return this.stderr != null;
    }

    @Override
    public Boolean getStdin() {
        return this.stdin;
    }

    @Override
    public A withStdin(Boolean stdin) {
        this.stdin = stdin;
        return (A)this;
    }

    @Override
    public Boolean hasStdin() {
        return this.stdin != null;
    }

    @Override
    public Boolean getStdout() {
        return this.stdout;
    }

    @Override
    public A withStdout(Boolean stdout) {
        this.stdout = stdout;
        return (A)this;
    }

    @Override
    public Boolean hasStdout() {
        return this.stdout != null;
    }

    @Override
    public Boolean getTty() {
        return this.tty;
    }

    @Override
    public A withTty(Boolean tty) {
        this.tty = tty;
        return (A)this;
    }

    @Override
    public Boolean hasTty() {
        return this.tty != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodExecOptionsFluentImpl that = (PodExecOptionsFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.command != null ? !this.command.equals(that.command) : that.command != null) {
            return false;
        }
        if (this.container != null ? !this.container.equals(that.container) : that.container != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.stderr != null ? !this.stderr.equals(that.stderr) : that.stderr != null) {
            return false;
        }
        if (this.stdin != null ? !this.stdin.equals(that.stdin) : that.stdin != null) {
            return false;
        }
        if (this.stdout != null ? !this.stdout.equals(that.stdout) : that.stdout != null) {
            return false;
        }
        return !(this.tty != null ? !this.tty.equals(that.tty) : that.tty != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.command, this.container, this.kind, this.stderr, this.stdin, this.stdout, this.tty, super.hashCode());
    }
}

