/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.informers.impl;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import io.fabric8.kubernetes.client.informers.ListerWatcher;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.SharedInformerEventListener;
import io.fabric8.kubernetes.client.informers.cache.Cache;
import io.fabric8.kubernetes.client.informers.cache.Controller;
import io.fabric8.kubernetes.client.informers.cache.DeltaFIFO;
import io.fabric8.kubernetes.client.informers.cache.Indexer;
import io.fabric8.kubernetes.client.informers.cache.ProcessorListener;
import io.fabric8.kubernetes.client.informers.cache.SharedProcessor;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSharedIndexInformer<T extends HasMetadata, L extends KubernetesResourceList<T>>
implements SharedIndexInformer<T> {
    private static final Logger log = LoggerFactory.getLogger(DefaultSharedIndexInformer.class);
    private static final long MINIMUM_RESYNC_PERIOD_MILLIS = 1000L;
    private long resyncCheckPeriodMillis;
    private long defaultEventHandlerResyncPeriod;
    private Indexer<T> indexer;
    private SharedProcessor<T> processor;
    private Controller<T, L> controller;
    private Thread controllerThread;
    private volatile boolean started = false;
    private volatile boolean stopped = false;

    public DefaultSharedIndexInformer(Class<T> apiTypeClass, ListerWatcher<T, L> listerWatcher, long resyncPeriod, OperationContext context, ConcurrentLinkedQueue<SharedInformerEventListener> eventListeners) {
        this.resyncCheckPeriodMillis = resyncPeriod;
        this.defaultEventHandlerResyncPeriod = resyncPeriod;
        this.processor = new SharedProcessor();
        this.indexer = new Cache();
        DeltaFIFO<HasMetadata> fifo = new DeltaFIFO<HasMetadata>(Cache::metaNamespaceKeyFunc, this.indexer);
        this.controller = new Controller<HasMetadata, L>(apiTypeClass, fifo, listerWatcher, this::handleDeltas, this.processor::shouldResync, this.resyncCheckPeriodMillis, context, eventListeners);
        this.controllerThread = new Thread(this.controller::run, "informer-controller-" + apiTypeClass.getSimpleName());
    }

    @Override
    public void addEventHandler(ResourceEventHandler<T> handler) {
        this.addEventHandlerWithResyncPeriod(handler, this.defaultEventHandlerResyncPeriod);
    }

    @Override
    public void addEventHandlerWithResyncPeriod(ResourceEventHandler<T> handler, long resyncPeriodMillis) {
        if (this.stopped) {
            log.info("DefaultSharedIndexInformer#Handler was not added to shared informer because it has stopped already");
            return;
        }
        if (resyncPeriodMillis > 0L) {
            if (resyncPeriodMillis < 1000L) {
                log.warn("DefaultSharedIndexInformer#resyncPeriod {} is too small. Changing it to minimal allowed value of {}", (Object)resyncPeriodMillis, (Object)1000L);
                resyncPeriodMillis = 1000L;
            }
            if (resyncPeriodMillis < this.resyncCheckPeriodMillis) {
                if (this.started) {
                    log.warn("DefaultSharedIndexInformer#resyncPeriod {} is smaller than resyncCheckPeriod {} and the informer has already started. Changing it to {}", (Object)resyncPeriodMillis, (Object)this.resyncCheckPeriodMillis);
                    resyncPeriodMillis = this.resyncCheckPeriodMillis;
                } else {
                    this.resyncCheckPeriodMillis = resyncPeriodMillis;
                }
            }
        }
        ProcessorListener listener = new ProcessorListener(handler, this.determineResyncPeriod(resyncPeriodMillis, this.resyncCheckPeriodMillis));
        if (!this.started) {
            this.processor.addListener(listener);
            return;
        }
        this.processor.addAndStartListener(listener);
        List objectList = this.indexer.list();
        for (Object item : objectList) {
            listener.add(new ProcessorListener.AddNotification(item));
        }
    }

    @Override
    public String lastSyncResourceVersion() {
        if (!this.started) {
            return "";
        }
        return this.controller.lastSyncResourceVersion();
    }

    @Override
    public void run() {
        if (this.started) {
            return;
        }
        this.started = true;
        this.processor.run();
        this.controllerThread.start();
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.stopped = true;
        this.controller.stop();
        this.controllerThread.interrupt();
        this.processor.stop();
    }

    @Override
    public boolean hasSynced() {
        return this.controller != null && this.controller.hasSynced();
    }

    private void handleDeltas(Deque<AbstractMap.SimpleEntry<DeltaFIFO.DeltaType, Object>> deltas) {
        if (deltas == null || deltas.isEmpty()) {
            return;
        }
        for (AbstractMap.SimpleEntry<DeltaFIFO.DeltaType, Object> delta : deltas) {
            DeltaFIFO.DeltaType deltaType = delta.getKey();
            switch (deltaType) {
                case SYNCHRONIZATION: 
                case ADDITION: 
                case UPDATION: {
                    boolean isSync = deltaType == DeltaFIFO.DeltaType.SYNCHRONIZATION;
                    Object oldObj = this.indexer.get((HasMetadata)delta.getValue());
                    if (oldObj != null) {
                        this.indexer.update((HasMetadata)delta.getValue());
                        this.processor.distribute(new ProcessorListener.UpdateNotification<Object>(oldObj, delta.getValue()), isSync);
                        break;
                    }
                    this.indexer.add((HasMetadata)delta.getValue());
                    this.processor.distribute(new ProcessorListener.AddNotification<Object>(delta.getValue()), isSync);
                    break;
                }
                case DELETION: {
                    if (!(delta.getValue() instanceof DeltaFIFO.DeletedFinalStateUnknown)) {
                        this.indexer.delete((HasMetadata)delta.getValue());
                    } else {
                        HasMetadata obj = (HasMetadata)((DeltaFIFO.DeletedFinalStateUnknown)delta.getValue()).getObj();
                        if (obj != null) {
                            this.indexer.delete(obj);
                        }
                    }
                    this.processor.distribute(new ProcessorListener.DeleteNotification<Object>(delta.getValue()), false);
                }
            }
        }
    }

    @Override
    public void addIndexers(Map<String, Function<T, List<String>>> indexers) {
        if (this.started) {
            throw new IllegalStateException("Cannot add indexers to a running informer.");
        }
        this.indexer.addIndexers(indexers);
    }

    @Override
    public Indexer getIndexer() {
        return this.indexer;
    }

    private long determineResyncPeriod(long desired, long check) {
        if (desired == 0L) {
            return desired;
        }
        if (check == 0L) {
            return 0L;
        }
        return desired < check ? check : desired;
    }
}

