/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_3.handlers;

import io.fabric8.kubernetes.api.model.v5_3.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_3.ListOptions;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_3.Watch;
import io.fabric8.kubernetes.clnt.v5_3.Watcher;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_3.NetNamespace;
import io.fabric8.openshift.api.model.v5_3.NetNamespaceBuilder;
import io.fabric8.openshift.clnt.v5_3.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.NetNamespaceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NetNamespaceHandler
implements ResourceHandler<NetNamespace, NetNamespaceBuilder> {
    @Override
    public String getKind() {
        return NetNamespace.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "network.openshift.io/v1";
    }

    @Override
    public NetNamespace create(OkHttpClient client, Config config, String namespace, NetNamespace item, boolean dryRun) {
        return (NetNamespace)((WritableOperation)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new NetNamespace[0]);
    }

    @Override
    public NetNamespace replace(OkHttpClient client, Config config, String namespace, NetNamespace item, boolean dryRun) {
        return ((WritableOperation)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public NetNamespace reload(OkHttpClient client, Config config, String namespace, NetNamespace item) {
        return (NetNamespace)((Gettable)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NetNamespaceBuilder edit(NetNamespace item) {
        return new NetNamespaceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, NetNamespace item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, Watcher<NetNamespace> watcher) {
        return ((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, String resourceVersion, Watcher<NetNamespace> watcher) {
        return ((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, NetNamespace item, ListOptions options, Watcher<NetNamespace> watcher) {
        return ((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public NetNamespace waitUntilReady(OkHttpClient client, Config config, String namespace, NetNamespace item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public NetNamespace waitUntilCondition(OkHttpClient client, Config config, String namespace, NetNamespace item, Predicate<NetNamespace> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (NetNamespace)((Resource)new NetNamespaceOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

