/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_3.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_3.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_3.KubernetesResourceList;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_3.internal.readiness.Readiness;
import io.fabric8.kubernetes.clnt.v5_3.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_3.utils.Utils;
import io.fabric8.openshift.clnt.v5_3.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_3.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v5_3.internal.readiness.OpenShiftReadiness;
import java.net.MalformedURLException;
import java.net.URL;

public class OpenShiftOperation<T extends HasMetadata, L extends KubernetesResourceList<T>, R extends Resource<T>>
extends HasMetadataOperation<T, L, R> {
    public static final String OPENSHIFT_APIGROUP_SUFFIX = "openshift.io";

    public OpenShiftOperation(OperationContext ctx) {
        super(OpenShiftOperation.wrap(ctx));
        this.updateApiVersion();
    }

    static OperationContext wrap(OperationContext context) {
        OpenShiftConfig config = OpenShiftConfig.wrap(context.getConfig());
        String oapiVersion = config.getOapiVersion();
        if (Utils.isNotNullOrEmpty(context.getApiGroupName())) {
            return OpenShiftOperation.getOperationContextWithApiGroupName(config, context, oapiVersion);
        }
        String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "oapi", oapiVersion);
        return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupVersion(oapiVersion);
    }

    static OperationContext getOperationContextWithApiGroupName(OpenShiftConfig config, OperationContext context, String oapiVersion) {
        String apiGroupVersionFromConfig;
        String string = apiGroupVersionFromConfig = Utils.isNotNullOrEmpty(context.getApiGroupVersion()) ? context.getApiGroupVersion() : oapiVersion;
        if (OpenShiftOperation.isOpenShiftApiGroup(context.getApiGroupName())) {
            return OpenShiftOperation.getOpenShiftOperationContext(config, context, apiGroupVersionFromConfig);
        }
        return OpenShiftOperation.getOperationContextWithApiGroupVersion(config, context, apiGroupVersionFromConfig);
    }

    private static OperationContext getOpenShiftOperationContext(OpenShiftConfig config, OperationContext context, String oapiVersion) {
        if (config.isOpenshiftApiGroupsEnabled()) {
            return OpenShiftOperation.getOperationContextWithApiGroupVersion(config, context, oapiVersion);
        }
        String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "oapi", oapiVersion);
        return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(oapiVersion);
    }

    private static OperationContext getOperationContextWithApiGroupVersion(OpenShiftConfig config, OperationContext context, String version) {
        String apiGroupUrl = URLUtils.join(config.getMasterUrl(), "apis", context.getApiGroupName(), version);
        String apiGroupVersion = URLUtils.join(context.getApiGroupName(), version);
        return context.withConfig(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(config).withOpenShiftUrl(apiGroupUrl)).build()).withApiGroupName(context.getApiGroupName()).withApiGroupVersion(apiGroupVersion);
    }

    private static boolean isOpenShiftApiGroup(String apiGroupName) {
        return apiGroupName.contains(OPENSHIFT_APIGROUP_SUFFIX);
    }

    @Override
    public OpenShiftConfig getConfig() {
        return OpenShiftConfig.wrap(super.getConfig());
    }

    @Override
    public URL getRootUrl() {
        if (Utils.isNullOrEmpty(this.context.getApiGroupName())) {
            try {
                return new URL(OpenShiftConfig.wrap(this.getConfig()).getOpenShiftUrl());
            }
            catch (MalformedURLException e) {
                throw KubernetesClientException.launderThrowable(e);
            }
        }
        return super.getRootUrl();
    }

    @Override
    public Readiness getReadiness() {
        return OpenShiftReadiness.getInstance();
    }

    private void updateApiVersion() {
        if (this.apiGroupName != null && this.apiGroupVersion != null) {
            this.apiVersion = this.apiGroupName + "/" + this.apiGroupVersion;
        } else if (this.apiGroupVersion != null) {
            this.apiVersion = this.apiGroupVersion;
        }
    }

    @Override
    protected Class<? extends Config> getConfigType() {
        return OpenShiftConfig.class;
    }
}

