/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_3;

import io.fabric8.kubernetes.api.builder.v5_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_3.Nested;
import io.fabric8.openshift.api.model.v5_3.ConfigMapNameReference;
import io.fabric8.openshift.api.model.v5_3.ConfigMapNameReferenceBuilder;
import io.fabric8.openshift.api.model.v5_3.ConfigMapNameReferenceFluentImpl;
import io.fabric8.openshift.api.model.v5_3.OpenIDClaims;
import io.fabric8.openshift.api.model.v5_3.OpenIDClaimsBuilder;
import io.fabric8.openshift.api.model.v5_3.OpenIDClaimsFluentImpl;
import io.fabric8.openshift.api.model.v5_3.OpenIDIdentityProvider;
import io.fabric8.openshift.api.model.v5_3.OpenIDIdentityProviderFluent;
import io.fabric8.openshift.api.model.v5_3.SecretNameReference;
import io.fabric8.openshift.api.model.v5_3.SecretNameReferenceBuilder;
import io.fabric8.openshift.api.model.v5_3.SecretNameReferenceFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OpenIDIdentityProviderFluentImpl<A extends OpenIDIdentityProviderFluent<A>>
extends BaseFluent<A>
implements OpenIDIdentityProviderFluent<A> {
    private ConfigMapNameReferenceBuilder ca;
    private OpenIDClaimsBuilder claims;
    private String clientID;
    private SecretNameReferenceBuilder clientSecret;
    private Map<String, String> extraAuthorizeParameters;
    private List<String> extraScopes = new ArrayList<String>();
    private String issuer;

    public OpenIDIdentityProviderFluentImpl() {
    }

    public OpenIDIdentityProviderFluentImpl(OpenIDIdentityProvider instance) {
        this.withCa(instance.getCa());
        this.withClaims(instance.getClaims());
        this.withClientID(instance.getClientID());
        this.withClientSecret(instance.getClientSecret());
        this.withExtraAuthorizeParameters(instance.getExtraAuthorizeParameters());
        this.withExtraScopes(instance.getExtraScopes());
        this.withIssuer(instance.getIssuer());
    }

    @Override
    @Deprecated
    public ConfigMapNameReference getCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    @Override
    public ConfigMapNameReference buildCa() {
        return this.ca != null ? this.ca.build() : null;
    }

    @Override
    public A withCa(ConfigMapNameReference ca) {
        this._visitables.get("ca").remove(this.ca);
        if (ca != null) {
            this.ca = new ConfigMapNameReferenceBuilder(ca);
            this._visitables.get("ca").add(this.ca);
        }
        return (A)this;
    }

    @Override
    public Boolean hasCa() {
        return this.ca != null;
    }

    @Override
    public A withNewCa(String name) {
        return this.withCa(new ConfigMapNameReference(name));
    }

    @Override
    public OpenIDIdentityProviderFluent.CaNested<A> withNewCa() {
        return new CaNestedImpl();
    }

    @Override
    public OpenIDIdentityProviderFluent.CaNested<A> withNewCaLike(ConfigMapNameReference item) {
        return new CaNestedImpl(item);
    }

    @Override
    public OpenIDIdentityProviderFluent.CaNested<A> editCa() {
        return this.withNewCaLike(this.getCa());
    }

    @Override
    public OpenIDIdentityProviderFluent.CaNested<A> editOrNewCa() {
        return this.withNewCaLike(this.getCa() != null ? this.getCa() : new ConfigMapNameReferenceBuilder().build());
    }

    @Override
    public OpenIDIdentityProviderFluent.CaNested<A> editOrNewCaLike(ConfigMapNameReference item) {
        return this.withNewCaLike(this.getCa() != null ? this.getCa() : item);
    }

    @Override
    @Deprecated
    public OpenIDClaims getClaims() {
        return this.claims != null ? this.claims.build() : null;
    }

    @Override
    public OpenIDClaims buildClaims() {
        return this.claims != null ? this.claims.build() : null;
    }

    @Override
    public A withClaims(OpenIDClaims claims) {
        this._visitables.get("claims").remove(this.claims);
        if (claims != null) {
            this.claims = new OpenIDClaimsBuilder(claims);
            this._visitables.get("claims").add(this.claims);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClaims() {
        return this.claims != null;
    }

    @Override
    public OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaims() {
        return new ClaimsNestedImpl();
    }

    @Override
    public OpenIDIdentityProviderFluent.ClaimsNested<A> withNewClaimsLike(OpenIDClaims item) {
        return new ClaimsNestedImpl(item);
    }

    @Override
    public OpenIDIdentityProviderFluent.ClaimsNested<A> editClaims() {
        return this.withNewClaimsLike(this.getClaims());
    }

    @Override
    public OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaims() {
        return this.withNewClaimsLike(this.getClaims() != null ? this.getClaims() : new OpenIDClaimsBuilder().build());
    }

    @Override
    public OpenIDIdentityProviderFluent.ClaimsNested<A> editOrNewClaimsLike(OpenIDClaims item) {
        return this.withNewClaimsLike(this.getClaims() != null ? this.getClaims() : item);
    }

    @Override
    public String getClientID() {
        return this.clientID;
    }

    @Override
    public A withClientID(String clientID) {
        this.clientID = clientID;
        return (A)this;
    }

    @Override
    public Boolean hasClientID() {
        return this.clientID != null;
    }

    @Override
    public A withNewClientID(StringBuilder arg1) {
        return this.withClientID(new String(arg1));
    }

    @Override
    public A withNewClientID(int[] arg1, int arg2, int arg3) {
        return this.withClientID(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClientID(char[] arg1) {
        return this.withClientID(new String(arg1));
    }

    @Override
    public A withNewClientID(StringBuffer arg1) {
        return this.withClientID(new String(arg1));
    }

    @Override
    public A withNewClientID(byte[] arg1, int arg2) {
        return this.withClientID(new String(arg1, arg2));
    }

    @Override
    public A withNewClientID(byte[] arg1) {
        return this.withClientID(new String(arg1));
    }

    @Override
    public A withNewClientID(char[] arg1, int arg2, int arg3) {
        return this.withClientID(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClientID(byte[] arg1, int arg2, int arg3) {
        return this.withClientID(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClientID(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withClientID(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewClientID(String arg1) {
        return this.withClientID(new String(arg1));
    }

    @Override
    @Deprecated
    public SecretNameReference getClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public SecretNameReference buildClientSecret() {
        return this.clientSecret != null ? this.clientSecret.build() : null;
    }

    @Override
    public A withClientSecret(SecretNameReference clientSecret) {
        this._visitables.get("clientSecret").remove(this.clientSecret);
        if (clientSecret != null) {
            this.clientSecret = new SecretNameReferenceBuilder(clientSecret);
            this._visitables.get("clientSecret").add(this.clientSecret);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientSecret() {
        return this.clientSecret != null;
    }

    @Override
    public A withNewClientSecret(String name) {
        return this.withClientSecret(new SecretNameReference(name));
    }

    @Override
    public OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecret() {
        return new ClientSecretNestedImpl();
    }

    @Override
    public OpenIDIdentityProviderFluent.ClientSecretNested<A> withNewClientSecretLike(SecretNameReference item) {
        return new ClientSecretNestedImpl(item);
    }

    @Override
    public OpenIDIdentityProviderFluent.ClientSecretNested<A> editClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret());
    }

    @Override
    public OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecret() {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : new SecretNameReferenceBuilder().build());
    }

    @Override
    public OpenIDIdentityProviderFluent.ClientSecretNested<A> editOrNewClientSecretLike(SecretNameReference item) {
        return this.withNewClientSecretLike(this.getClientSecret() != null ? this.getClientSecret() : item);
    }

    @Override
    public A addToExtraAuthorizeParameters(String key, String value) {
        if (this.extraAuthorizeParameters == null && key != null && value != null) {
            this.extraAuthorizeParameters = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.extraAuthorizeParameters.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToExtraAuthorizeParameters(Map<String, String> map) {
        if (this.extraAuthorizeParameters == null && map != null) {
            this.extraAuthorizeParameters = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.extraAuthorizeParameters.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtraAuthorizeParameters(String key) {
        if (this.extraAuthorizeParameters == null) {
            return (A)this;
        }
        if (key != null && this.extraAuthorizeParameters != null) {
            this.extraAuthorizeParameters.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtraAuthorizeParameters(Map<String, String> map) {
        if (this.extraAuthorizeParameters == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.extraAuthorizeParameters == null) continue;
                this.extraAuthorizeParameters.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, String> getExtraAuthorizeParameters() {
        return this.extraAuthorizeParameters;
    }

    @Override
    public <K, V> A withExtraAuthorizeParameters(Map<String, String> extraAuthorizeParameters) {
        this.extraAuthorizeParameters = extraAuthorizeParameters == null ? null : new LinkedHashMap<String, String>(extraAuthorizeParameters);
        return (A)this;
    }

    @Override
    public Boolean hasExtraAuthorizeParameters() {
        return this.extraAuthorizeParameters != null;
    }

    @Override
    public A addToExtraScopes(int index, String item) {
        if (this.extraScopes == null) {
            this.extraScopes = new ArrayList<String>();
        }
        this.extraScopes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToExtraScopes(int index, String item) {
        if (this.extraScopes == null) {
            this.extraScopes = new ArrayList<String>();
        }
        this.extraScopes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToExtraScopes(String ... items) {
        if (this.extraScopes == null) {
            this.extraScopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraScopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToExtraScopes(Collection<String> items) {
        if (this.extraScopes == null) {
            this.extraScopes = new ArrayList<String>();
        }
        for (String item : items) {
            this.extraScopes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromExtraScopes(String ... items) {
        for (String item : items) {
            if (this.extraScopes == null) continue;
            this.extraScopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromExtraScopes(Collection<String> items) {
        for (String item : items) {
            if (this.extraScopes == null) continue;
            this.extraScopes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getExtraScopes() {
        return this.extraScopes;
    }

    @Override
    public String getExtraScope(int index) {
        return this.extraScopes.get(index);
    }

    @Override
    public String getFirstExtraScope() {
        return this.extraScopes.get(0);
    }

    @Override
    public String getLastExtraScope() {
        return this.extraScopes.get(this.extraScopes.size() - 1);
    }

    @Override
    public String getMatchingExtraScope(Predicate<String> predicate) {
        for (String item : this.extraScopes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingExtraScope(Predicate<String> predicate) {
        for (String item : this.extraScopes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withExtraScopes(List<String> extraScopes) {
        if (this.extraScopes != null) {
            this._visitables.get("extraScopes").removeAll(this.extraScopes);
        }
        if (extraScopes != null) {
            this.extraScopes = new ArrayList<String>();
            for (String item : extraScopes) {
                this.addToExtraScopes(item);
            }
        } else {
            this.extraScopes = null;
        }
        return (A)this;
    }

    @Override
    public A withExtraScopes(String ... extraScopes) {
        if (this.extraScopes != null) {
            this.extraScopes.clear();
        }
        if (extraScopes != null) {
            for (String item : extraScopes) {
                this.addToExtraScopes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasExtraScopes() {
        return this.extraScopes != null && !this.extraScopes.isEmpty();
    }

    @Override
    public A addNewExtraScope(StringBuilder arg1) {
        return this.addToExtraScopes(new String(arg1));
    }

    @Override
    public A addNewExtraScope(int[] arg1, int arg2, int arg3) {
        return this.addToExtraScopes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewExtraScope(char[] arg1) {
        return this.addToExtraScopes(new String(arg1));
    }

    @Override
    public A addNewExtraScope(StringBuffer arg1) {
        return this.addToExtraScopes(new String(arg1));
    }

    @Override
    public A addNewExtraScope(byte[] arg1, int arg2) {
        return this.addToExtraScopes(new String(arg1, arg2));
    }

    @Override
    public A addNewExtraScope(byte[] arg1) {
        return this.addToExtraScopes(new String(arg1));
    }

    @Override
    public A addNewExtraScope(char[] arg1, int arg2, int arg3) {
        return this.addToExtraScopes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewExtraScope(byte[] arg1, int arg2, int arg3) {
        return this.addToExtraScopes(new String(arg1, arg2, arg3));
    }

    @Override
    public A addNewExtraScope(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.addToExtraScopes(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A addNewExtraScope(String arg1) {
        return this.addToExtraScopes(new String(arg1));
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public A withIssuer(String issuer) {
        this.issuer = issuer;
        return (A)this;
    }

    @Override
    public Boolean hasIssuer() {
        return this.issuer != null;
    }

    @Override
    public A withNewIssuer(StringBuilder arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public A withNewIssuer(int[] arg1, int arg2, int arg3) {
        return this.withIssuer(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewIssuer(char[] arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public A withNewIssuer(StringBuffer arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public A withNewIssuer(byte[] arg1, int arg2) {
        return this.withIssuer(new String(arg1, arg2));
    }

    @Override
    public A withNewIssuer(byte[] arg1) {
        return this.withIssuer(new String(arg1));
    }

    @Override
    public A withNewIssuer(char[] arg1, int arg2, int arg3) {
        return this.withIssuer(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewIssuer(byte[] arg1, int arg2, int arg3) {
        return this.withIssuer(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewIssuer(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withIssuer(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewIssuer(String arg1) {
        return this.withIssuer(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OpenIDIdentityProviderFluentImpl that = (OpenIDIdentityProviderFluentImpl)o;
        if (this.ca != null ? !this.ca.equals(that.ca) : that.ca != null) {
            return false;
        }
        if (this.claims != null ? !this.claims.equals(that.claims) : that.claims != null) {
            return false;
        }
        if (this.clientID != null ? !this.clientID.equals(that.clientID) : that.clientID != null) {
            return false;
        }
        if (this.clientSecret != null ? !this.clientSecret.equals(that.clientSecret) : that.clientSecret != null) {
            return false;
        }
        if (this.extraAuthorizeParameters != null ? !this.extraAuthorizeParameters.equals(that.extraAuthorizeParameters) : that.extraAuthorizeParameters != null) {
            return false;
        }
        if (this.extraScopes != null ? !this.extraScopes.equals(that.extraScopes) : that.extraScopes != null) {
            return false;
        }
        return !(this.issuer != null ? !this.issuer.equals(that.issuer) : that.issuer != null);
    }

    public int hashCode() {
        return Objects.hash(this.ca, this.claims, this.clientID, this.clientSecret, this.extraAuthorizeParameters, this.extraScopes, this.issuer, super.hashCode());
    }

    public class ClientSecretNestedImpl<N>
    extends SecretNameReferenceFluentImpl<OpenIDIdentityProviderFluent.ClientSecretNested<N>>
    implements OpenIDIdentityProviderFluent.ClientSecretNested<N>,
    Nested<N> {
        private final SecretNameReferenceBuilder builder;

        ClientSecretNestedImpl(SecretNameReference item) {
            this.builder = new SecretNameReferenceBuilder(this, item);
        }

        ClientSecretNestedImpl() {
            this.builder = new SecretNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpenIDIdentityProviderFluentImpl.this.withClientSecret(this.builder.build());
        }

        @Override
        public N endClientSecret() {
            return this.and();
        }
    }

    public class ClaimsNestedImpl<N>
    extends OpenIDClaimsFluentImpl<OpenIDIdentityProviderFluent.ClaimsNested<N>>
    implements OpenIDIdentityProviderFluent.ClaimsNested<N>,
    Nested<N> {
        private final OpenIDClaimsBuilder builder;

        ClaimsNestedImpl(OpenIDClaims item) {
            this.builder = new OpenIDClaimsBuilder(this, item);
        }

        ClaimsNestedImpl() {
            this.builder = new OpenIDClaimsBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpenIDIdentityProviderFluentImpl.this.withClaims(this.builder.build());
        }

        @Override
        public N endClaims() {
            return this.and();
        }
    }

    public class CaNestedImpl<N>
    extends ConfigMapNameReferenceFluentImpl<OpenIDIdentityProviderFluent.CaNested<N>>
    implements OpenIDIdentityProviderFluent.CaNested<N>,
    Nested<N> {
        private final ConfigMapNameReferenceBuilder builder;

        CaNestedImpl(ConfigMapNameReference item) {
            this.builder = new ConfigMapNameReferenceBuilder(this, item);
        }

        CaNestedImpl() {
            this.builder = new ConfigMapNameReferenceBuilder(this);
        }

        @Override
        public N and() {
            return (N)OpenIDIdentityProviderFluentImpl.this.withCa(this.builder.build());
        }

        @Override
        public N endCa() {
            return this.and();
        }
    }
}

