/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_3;

import io.fabric8.kubernetes.api.builder.v5_3.VisitableBuilder;
import io.fabric8.openshift.api.model.v5_3.BuildConfig;
import io.fabric8.openshift.api.model.v5_3.BuildConfigFluent;
import io.fabric8.openshift.api.model.v5_3.BuildConfigFluentImpl;
import java.util.Objects;

public class BuildConfigBuilder
extends BuildConfigFluentImpl<BuildConfigBuilder>
implements VisitableBuilder<BuildConfig, BuildConfigBuilder> {
    BuildConfigFluent<?> fluent;
    Boolean validationEnabled;

    public BuildConfigBuilder() {
        this(true);
    }

    public BuildConfigBuilder(Boolean validationEnabled) {
        this(new BuildConfig(), validationEnabled);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new BuildConfig(), validationEnabled);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, BuildConfig instance) {
        this(fluent, instance, true);
    }

    public BuildConfigBuilder(BuildConfigFluent<?> fluent, BuildConfig instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public BuildConfigBuilder(BuildConfig instance) {
        this(instance, (Boolean)true);
    }

    public BuildConfigBuilder(BuildConfig instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public BuildConfig build() {
        BuildConfig buildable = new BuildConfig(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildConfigBuilder that = (BuildConfigBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

