/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.internal.readiness;

import io.fabric8.kubernetes.api.model.v5_3.EndpointSubset;
import io.fabric8.kubernetes.api.model.v5_3.Endpoints;
import io.fabric8.kubernetes.api.model.v5_3.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_3.Node;
import io.fabric8.kubernetes.api.model.v5_3.NodeCondition;
import io.fabric8.kubernetes.api.model.v5_3.Pod;
import io.fabric8.kubernetes.api.model.v5_3.PodCondition;
import io.fabric8.kubernetes.api.model.v5_3.ReplicationController;
import io.fabric8.kubernetes.api.model.v5_3.ReplicationControllerSpec;
import io.fabric8.kubernetes.api.model.v5_3.ReplicationControllerStatus;
import io.fabric8.kubernetes.api.model.v5_3.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v5_3.apps.ReplicaSetSpec;
import io.fabric8.kubernetes.api.model.v5_3.apps.ReplicaSetStatus;
import io.fabric8.kubernetes.api.model.v5_3.apps.StatefulSet;
import io.fabric8.kubernetes.api.model.v5_3.apps.StatefulSetSpec;
import io.fabric8.kubernetes.api.model.v5_3.apps.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.v5_3.extensions.Deployment;
import io.fabric8.kubernetes.api.model.v5_3.extensions.DeploymentSpec;
import io.fabric8.kubernetes.api.model.v5_3.extensions.DeploymentStatus;
import io.fabric8.kubernetes.clnt.v5_3.utils.Utils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Readiness {
    private static final String POD_READY = "Ready";
    private static final String NODE_READY = "Ready";
    private static final String TRUE = "True";
    private static final Logger logger = LoggerFactory.getLogger(Readiness.class);
    protected static final String READINESS_APPLICABLE_RESOURCES = "Node, Deployment, ReplicaSet, StatefulSet, Pod, ReplicationController";

    public static Readiness getInstance() {
        return ReadinessHolder.INSTANCE;
    }

    public boolean isReady(HasMetadata item) {
        if (this.isReadinessApplicable(item)) {
            return this.isResourceReady(item);
        }
        return this.handleNonReadinessApplicableResource(item);
    }

    protected boolean isReadinessApplicable(HasMetadata item) {
        return item instanceof io.fabric8.kubernetes.api.model.v5_3.apps.Deployment || item instanceof Deployment || item instanceof ReplicaSet || item instanceof Pod || item instanceof ReplicationController || item instanceof Endpoints || item instanceof Node || item instanceof StatefulSet;
    }

    protected boolean isResourceReady(HasMetadata item) {
        if (item instanceof io.fabric8.kubernetes.api.model.v5_3.apps.Deployment) {
            return Readiness.isDeploymentReady((io.fabric8.kubernetes.api.model.v5_3.apps.Deployment)item);
        }
        if (item instanceof Deployment) {
            return Readiness.isExtensionsDeploymentReady((Deployment)item);
        }
        if (item instanceof ReplicaSet) {
            return Readiness.isReplicaSetReady((ReplicaSet)item);
        }
        if (item instanceof Pod) {
            return Readiness.isPodReady((Pod)item);
        }
        if (item instanceof ReplicationController) {
            return Readiness.isReplicationControllerReady((ReplicationController)item);
        }
        if (item instanceof Endpoints) {
            return Readiness.isEndpointsReady((Endpoints)item);
        }
        if (item instanceof Node) {
            return Readiness.isNodeReady((Node)item);
        }
        if (item instanceof StatefulSet) {
            return Readiness.isStatefulSetReady((StatefulSet)item);
        }
        return false;
    }

    protected String getReadinessResourcesList() {
        return READINESS_APPLICABLE_RESOURCES;
    }

    final boolean handleNonReadinessApplicableResource(HasMetadata item) {
        boolean doesItemExist = Objects.nonNull(item);
        logger.warn("{} is not a Readiable resource. It needs to be one of [{}]", (Object)(doesItemExist ? item.getKind() : "Unknown"), (Object)this.getReadinessResourcesList());
        return doesItemExist;
    }

    public static boolean isStatefulSetReady(StatefulSet ss) {
        Utils.checkNotNull(ss, "StatefulSet can't be null.");
        StatefulSetSpec spec = ss.getSpec();
        StatefulSetStatus status = ss.getStatus();
        if (status == null || status.getReplicas() == null || status.getReadyReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isDeploymentReady(io.fabric8.kubernetes.api.model.v5_3.apps.Deployment d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        io.fabric8.kubernetes.api.model.v5_3.apps.DeploymentSpec spec = d.getSpec();
        io.fabric8.kubernetes.api.model.v5_3.apps.DeploymentStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }

    public static boolean isExtensionsDeploymentReady(Deployment d) {
        Utils.checkNotNull(d, "Deployment can't be null.");
        DeploymentSpec spec = d.getSpec();
        DeploymentStatus status = d.getStatus();
        if (status == null || status.getReplicas() == null || status.getAvailableReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReplicas().intValue() && spec.getReplicas() <= status.getAvailableReplicas();
    }

    public static boolean isReplicaSetReady(ReplicaSet r) {
        Utils.checkNotNull(r, "ReplicationController can't be null.");
        ReplicaSetSpec spec = r.getSpec();
        ReplicaSetStatus status = r.getStatus();
        if (status == null || status.getReadyReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isReplicationControllerReady(ReplicationController r) {
        Utils.checkNotNull(r, "ReplicationController can't be null.");
        ReplicationControllerSpec spec = r.getSpec();
        ReplicationControllerStatus status = r.getStatus();
        if (status == null || status.getReadyReplicas() == null) {
            return false;
        }
        if (spec == null || spec.getReplicas() == null) {
            return false;
        }
        return spec.getReplicas().intValue() == status.getReadyReplicas().intValue();
    }

    public static boolean isEndpointsReady(Endpoints e) {
        Utils.checkNotNull(e, "Endpoints can't be null.");
        String name = e.getMetadata().getName();
        Utils.checkNotNull(name, "Endpoints name can't be null.");
        if (e.getSubsets() == null) {
            return false;
        }
        for (EndpointSubset subset : e.getSubsets()) {
            if (subset.getAddresses().isEmpty() || subset.getPorts().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isPodReady(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        PodCondition condition = Readiness.getPodReadyCondition(pod);
        if (condition == null || condition.getStatus() == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase(TRUE);
    }

    private static PodCondition getPodReadyCondition(Pod pod) {
        Utils.checkNotNull(pod, "Pod can't be null.");
        if (pod.getStatus() == null || pod.getStatus().getConditions() == null) {
            return null;
        }
        for (PodCondition condition : pod.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }

    public static boolean isNodeReady(Node node) {
        Utils.checkNotNull(node, "Node can't be null.");
        NodeCondition condition = Readiness.getNodeReadyCondition(node);
        if (condition == null || condition.getStatus() == null) {
            return false;
        }
        return condition.getStatus().equalsIgnoreCase(TRUE);
    }

    private static NodeCondition getNodeReadyCondition(Node node) {
        Utils.checkNotNull(node, "Node can't be null.");
        if (node.getStatus() == null || node.getStatus().getConditions() == null) {
            return null;
        }
        for (NodeCondition condition : node.getStatus().getConditions()) {
            if (!"Ready".equals(condition.getType())) continue;
            return condition;
        }
        return null;
    }

    private static class ReadinessHolder {
        public static final Readiness INSTANCE = new Readiness();

        private ReadinessHolder() {
        }
    }
}

