/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.handlers.core.v1;

import io.fabric8.kubernetes.api.model.v5_3.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_3.ListOptions;
import io.fabric8.kubernetes.api.model.v5_3.Service;
import io.fabric8.kubernetes.api.model.v5_3.ServiceBuilder;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_3.Watch;
import io.fabric8.kubernetes.clnt.v5_3.Watcher;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.core.v1.ServiceOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ServiceHandler
implements ResourceHandler<Service, ServiceBuilder> {
    @Override
    public String getKind() {
        return Service.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "v1";
    }

    @Override
    public Service create(OkHttpClient client, Config config, String namespace, Service item, boolean dryRun) {
        return (Service)((WritableOperation)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Service[0]);
    }

    @Override
    public Service replace(OkHttpClient client, Config config, String namespace, Service item, boolean dryRun) {
        return ((WritableOperation)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Service reload(OkHttpClient client, Config config, String namespace, Service item) {
        return (Service)((Gettable)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public ServiceBuilder edit(Service item) {
        return new ServiceBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Service item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new ServiceOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Service item, Watcher<Service> watcher) {
        return ((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Service item, String resourceVersion, Watcher<Service> watcher) {
        return ((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Service item, ListOptions options, Watcher<Service> watcher) {
        return ((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Service waitUntilReady(OkHttpClient client, Config config, String namespace, Service item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Service)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Service waitUntilCondition(OkHttpClient client, Config config, String namespace, Service item, Predicate<Service> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Service)((ServiceResource)new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

