/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.dsl.internal;

import io.fabric8.kubernetes.clnt.v5_3.LocalPortForward;
import io.fabric8.kubernetes.clnt.v5_3.PortForward;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.PortForwarder;
import io.fabric8.kubernetes.clnt.v5_3.utils.URLUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortForwarderWebsocket
implements PortForwarder {
    private static final Logger LOG = LoggerFactory.getLogger(PortForwarderWebsocket.class);
    private final OkHttpClient client;

    public PortForwarderWebsocket(OkHttpClient client) {
        this.client = client;
    }

    @Override
    public LocalPortForward forward(URL resourceBaseUrl, int port) {
        return this.forward(resourceBaseUrl, port, 0);
    }

    @Override
    public LocalPortForward forward(URL resourceBaseUrl, int port, int localPort) {
        return this.forward(resourceBaseUrl, port, null, localPort);
    }

    @Override
    public LocalPortForward forward(URL resourceBaseUrl, int port, InetAddress localHost, int localPort) {
        try {
            final ServerSocketChannel server = localHost == null ? ServerSocketChannel.open().bind(new InetSocketAddress(localPort)) : ServerSocketChannel.open().bind(new InetSocketAddress(localHost, localPort));
            final AtomicBoolean alive = new AtomicBoolean(true);
            final CopyOnWriteArrayList handles = new CopyOnWriteArrayList();
            final ExecutorService executorService = Executors.newSingleThreadExecutor();
            LocalPortForward localPortForwardHandle = new LocalPortForward(){

                @Override
                public void close() throws IOException {
                    alive.set(false);
                    try {
                        server.close();
                    }
                    finally {
                        PortForwarderWebsocket.closeQuietly(handles.toArray(new Closeable[0]));
                        PortForwarderWebsocket.this.closeExecutor(executorService);
                    }
                }

                @Override
                public boolean isAlive() {
                    return alive.get();
                }

                @Override
                public boolean errorOccurred() {
                    for (PortForward handle : handles) {
                        if (!handle.errorOccurred()) continue;
                        return true;
                    }
                    return false;
                }

                @Override
                public InetAddress getLocalAddress() {
                    try {
                        return ((InetSocketAddress)server.getLocalAddress()).getAddress();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot determine local address", e);
                    }
                }

                @Override
                public int getLocalPort() {
                    try {
                        return ((InetSocketAddress)server.getLocalAddress()).getPort();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot determine local address", e);
                    }
                }

                @Override
                public Collection<Throwable> getClientThrowables() {
                    ArrayList<Throwable> clientThrowables = new ArrayList<Throwable>();
                    for (PortForward handle : handles) {
                        clientThrowables.addAll(handle.getClientThrowables());
                    }
                    return clientThrowables;
                }

                @Override
                public Collection<Throwable> getServerThrowables() {
                    ArrayList<Throwable> serverThrowables = new ArrayList<Throwable>();
                    for (PortForward handle : handles) {
                        serverThrowables.addAll(handle.getServerThrowables());
                    }
                    return serverThrowables;
                }
            };
            executorService.execute(() -> {
                while (alive.get()) {
                    try {
                        SocketChannel socket = server.accept();
                        handles.add(this.forward(resourceBaseUrl, port, socket, socket));
                    }
                    catch (IOException e) {
                        if (alive.get()) {
                            LOG.error("Error while listening for connections", (Throwable)e);
                        }
                        PortForwarderWebsocket.closeQuietly(localPortForwardHandle);
                    }
                }
            });
            return localPortForwardHandle;
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to port forward", e);
        }
    }

    @Override
    public PortForward forward(URL resourceBaseUrl, int port, final ReadableByteChannel in, final WritableByteChannel out) {
        final AtomicBoolean alive = new AtomicBoolean(true);
        final AtomicBoolean errorOccurred = new AtomicBoolean(false);
        final Collection clientThrowables = Collections.synchronizedCollection(new ArrayList());
        final Collection serverThrowables = Collections.synchronizedCollection(new ArrayList());
        String logPrefix = "FWD";
        Request request = new Request.Builder().get().url(URLUtils.join(resourceBaseUrl.toString(), "portforward?ports=" + port)).build();
        final WebSocket socket = this.client.newWebSocket(request, new WebSocketListener(){
            private int messagesRead = 0;
            private final ExecutorService pumperService = Executors.newSingleThreadExecutor();

            public void onOpen(WebSocket webSocket, Response response) {
                LOG.debug("{}: onOpen", (Object)"FWD");
                if (in != null) {
                    this.pumperService.execute(() -> {
                        block3: {
                            ByteBuffer buffer = ByteBuffer.allocate(4096);
                            try {
                                int read;
                                do {
                                    buffer.clear();
                                    buffer.put((byte)0);
                                    read = in.read(buffer);
                                    if (read <= 0) continue;
                                    buffer.flip();
                                    ByteString data = ByteString.of((ByteBuffer)buffer);
                                    webSocket.send(data);
                                } while (alive.get() && read >= 0);
                            }
                            catch (IOException e) {
                                if (!alive.get()) break block3;
                                clientThrowables.add(e);
                                LOG.error("Error while writing client data");
                                this.closeBothWays(webSocket, 1001, "Client error");
                            }
                        }
                    });
                }
            }

            public void onMessage(WebSocket webSocket, String text) {
                LOG.debug("{}: onMessage(String)", (Object)"FWD");
                this.onMessage(webSocket, ByteBuffer.wrap(text.getBytes(StandardCharsets.UTF_8)));
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                LOG.debug("{}: onMessage(ByteString)", (Object)"FWD");
                this.onMessage(webSocket, bytes.asByteBuffer());
            }

            private void onMessage(WebSocket webSocket, ByteBuffer buffer) {
                block9: {
                    byte channel;
                    ++this.messagesRead;
                    if (this.messagesRead <= 2) {
                        return;
                    }
                    if (!buffer.hasRemaining()) {
                        errorOccurred.set(true);
                        LOG.error("Received an empty message");
                        this.closeBothWays(webSocket, 1002, "Protocol error");
                    }
                    if ((channel = buffer.get()) < 0 || channel > 1) {
                        errorOccurred.set(true);
                        LOG.error("Received a wrong channel from the remote socket: {}", (Object)channel);
                        this.closeBothWays(webSocket, 1002, "Protocol error");
                    } else if (channel == 1) {
                        errorOccurred.set(true);
                        LOG.error("Received an error from the remote socket");
                        this.closeForwarder();
                    } else if (out != null) {
                        try {
                            out.write(buffer);
                        }
                        catch (IOException e) {
                            if (!alive.get()) break block9;
                            clientThrowables.add(e);
                            LOG.error("Error while forwarding data to the client", (Throwable)e);
                            this.closeBothWays(webSocket, 1002, "Protocol error");
                        }
                    }
                }
            }

            public void onClosing(WebSocket webSocket, int code, String reason) {
                LOG.debug("{}: onClosing. Code={}, Reason={}", new Object[]{"FWD", code, reason});
                if (alive.get()) {
                    this.closeForwarder();
                }
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                LOG.debug("{}: onClosed. Code={}, Reason={}", new Object[]{"FWD", code, reason});
                if (alive.get()) {
                    this.closeForwarder();
                }
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                LOG.debug("{}: onFailure", (Object)"FWD");
                if (alive.get()) {
                    serverThrowables.add(t);
                    LOG.error("{}: Throwable received from websocket", (Object)"FWD", (Object)t);
                    this.closeForwarder();
                }
            }

            private void closeBothWays(WebSocket webSocket, int code, String message) {
                LOG.debug("{}: Closing with code {} and reason: {}", new Object[]{"FWD", code, message});
                alive.set(false);
                try {
                    webSocket.close(code, message);
                }
                catch (Exception e) {
                    serverThrowables.add(e);
                    LOG.error("Error while closing the websocket", (Throwable)e);
                }
                this.closeForwarder();
            }

            private void closeForwarder() {
                alive.set(false);
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOG.error("{}: Error while closing the client input channel", (Object)"FWD", (Object)e);
                    }
                }
                if (out != null && out != in) {
                    try {
                        out.close();
                    }
                    catch (IOException e) {
                        LOG.error("{}: Error while closing the client output channel", (Object)"FWD", (Object)e);
                    }
                }
                PortForwarderWebsocket.this.closeExecutor(this.pumperService);
            }
        });
        return new PortForward(){

            @Override
            public void close() throws IOException {
                socket.close(1001, "User closing");
            }

            @Override
            public boolean isAlive() {
                return alive.get();
            }

            @Override
            public boolean errorOccurred() {
                return errorOccurred.get() || !clientThrowables.isEmpty() || !serverThrowables.isEmpty();
            }

            @Override
            public Collection<Throwable> getClientThrowables() {
                return clientThrowables;
            }

            @Override
            public Collection<Throwable> getServerThrowables() {
                return serverThrowables;
            }
        };
    }

    private void closeExecutor(ExecutorService executor) {
        try {
            executor.shutdown();
            if (!executor.awaitTermination(5L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
                if (!executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    LOG.error("The executor service did not terminate");
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            LOG.error("Error while closing the executor", (Throwable)e);
        }
    }

    public static void closeQuietly(Closeable ... cloaseables) {
        if (cloaseables != null) {
            for (Closeable c : cloaseables) {
                try {
                    if (c == null) continue;
                    c.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

