/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_3.storage.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_3.storage.v1beta1.CSINode;
import io.fabric8.kubernetes.api.model.v5_3.storage.v1beta1.CSINodeFluent;
import io.fabric8.kubernetes.api.model.v5_3.storage.v1beta1.CSINodeFluentImpl;
import java.util.Objects;

public class CSINodeBuilder
extends CSINodeFluentImpl<CSINodeBuilder>
implements VisitableBuilder<CSINode, CSINodeBuilder> {
    CSINodeFluent<?> fluent;
    Boolean validationEnabled;

    public CSINodeBuilder() {
        this(true);
    }

    public CSINodeBuilder(Boolean validationEnabled) {
        this(new CSINode(), validationEnabled);
    }

    public CSINodeBuilder(CSINodeFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CSINodeBuilder(CSINodeFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CSINode(), validationEnabled);
    }

    public CSINodeBuilder(CSINodeFluent<?> fluent, CSINode instance) {
        this(fluent, instance, true);
    }

    public CSINodeBuilder(CSINodeFluent<?> fluent, CSINode instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    public CSINodeBuilder(CSINode instance) {
        this(instance, (Boolean)true);
    }

    public CSINodeBuilder(CSINode instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CSINode build() {
        CSINode buildable = new CSINode(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSINodeBuilder that = (CSINodeBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

