/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1;

import io.fabric8.kubernetes.api.builder.v5_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_3.Nested;
import io.fabric8.kubernetes.api.model.v5_3.ObjectMeta;
import io.fabric8.kubernetes.api.model.v5_3.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.v5_3.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1.Endpoint;
import io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1.EndpointBuilder;
import io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1.EndpointFluentImpl;
import io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1.EndpointPort;
import io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1.EndpointPortBuilder;
import io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1.EndpointPortFluentImpl;
import io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1.EndpointSlice;
import io.fabric8.kubernetes.api.model.v5_3.discovery.v1beta1.EndpointSliceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class EndpointSliceFluentImpl<A extends EndpointSliceFluent<A>>
extends BaseFluent<A>
implements EndpointSliceFluent<A> {
    private String addressType;
    private String apiVersion;
    private List<EndpointBuilder> endpoints = new ArrayList<EndpointBuilder>();
    private String kind;
    private ObjectMetaBuilder metadata;
    private List<EndpointPortBuilder> ports = new ArrayList<EndpointPortBuilder>();

    public EndpointSliceFluentImpl() {
    }

    public EndpointSliceFluentImpl(EndpointSlice instance) {
        this.withAddressType(instance.getAddressType());
        this.withApiVersion(instance.getApiVersion());
        this.withEndpoints(instance.getEndpoints());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withPorts(instance.getPorts());
    }

    @Override
    public String getAddressType() {
        return this.addressType;
    }

    @Override
    public A withAddressType(String addressType) {
        this.addressType = addressType;
        return (A)this;
    }

    @Override
    public Boolean hasAddressType() {
        return this.addressType != null;
    }

    @Override
    public A withNewAddressType(StringBuilder arg1) {
        return this.withAddressType(new String(arg1));
    }

    @Override
    public A withNewAddressType(int[] arg1, int arg2, int arg3) {
        return this.withAddressType(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewAddressType(char[] arg1) {
        return this.withAddressType(new String(arg1));
    }

    @Override
    public A withNewAddressType(StringBuffer arg1) {
        return this.withAddressType(new String(arg1));
    }

    @Override
    public A withNewAddressType(byte[] arg1, int arg2) {
        return this.withAddressType(new String(arg1, arg2));
    }

    @Override
    public A withNewAddressType(byte[] arg1) {
        return this.withAddressType(new String(arg1));
    }

    @Override
    public A withNewAddressType(char[] arg1, int arg2, int arg3) {
        return this.withAddressType(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewAddressType(byte[] arg1, int arg2, int arg3) {
        return this.withAddressType(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewAddressType(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withAddressType(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewAddressType(String arg1) {
        return this.withAddressType(new String(arg1));
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(int[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(char[] arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2) {
        return this.withApiVersion(new String(arg1, arg2));
    }

    @Override
    public A withNewApiVersion(byte[] arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(char[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        this._visitables.get("endpoints").add(index >= 0 ? index : this._visitables.get("endpoints").size(), builder);
        this.endpoints.add(index >= 0 ? index : this.endpoints.size(), builder);
        return (A)this;
    }

    @Override
    public A setToEndpoints(int index, Endpoint item) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        EndpointBuilder builder = new EndpointBuilder(item);
        if (index < 0 || index >= this._visitables.get("endpoints").size()) {
            this._visitables.get("endpoints").add(builder);
        } else {
            this._visitables.get("endpoints").set(index, builder);
        }
        if (index < 0 || index >= this.endpoints.size()) {
            this.endpoints.add(builder);
        } else {
            this.endpoints.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToEndpoints(Endpoint ... items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToEndpoints(Collection<Endpoint> items) {
        if (this.endpoints == null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
        }
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").add(builder);
            this.endpoints.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromEndpoints(Endpoint ... items) {
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromEndpoints(Collection<Endpoint> items) {
        for (Endpoint item : items) {
            EndpointBuilder builder = new EndpointBuilder(item);
            this._visitables.get("endpoints").remove(builder);
            if (this.endpoints == null) continue;
            this.endpoints.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromEndpoints(Predicate<EndpointBuilder> predicate) {
        if (this.endpoints == null) {
            return (A)this;
        }
        Iterator<EndpointBuilder> each = this.endpoints.iterator();
        Object visitables = this._visitables.get("endpoints");
        while (each.hasNext()) {
            EndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<Endpoint> getEndpoints() {
        return EndpointSliceFluentImpl.build(this.endpoints);
    }

    @Override
    public List<Endpoint> buildEndpoints() {
        return EndpointSliceFluentImpl.build(this.endpoints);
    }

    @Override
    public Endpoint buildEndpoint(int index) {
        return this.endpoints.get(index).build();
    }

    @Override
    public Endpoint buildFirstEndpoint() {
        return this.endpoints.get(0).build();
    }

    @Override
    public Endpoint buildLastEndpoint() {
        return this.endpoints.get(this.endpoints.size() - 1).build();
    }

    @Override
    public Endpoint buildMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        for (EndpointBuilder item : this.endpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withEndpoints(List<Endpoint> endpoints) {
        if (this.endpoints != null) {
            this._visitables.get("endpoints").removeAll(this.endpoints);
        }
        if (endpoints != null) {
            this.endpoints = new ArrayList<EndpointBuilder>();
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        } else {
            this.endpoints = null;
        }
        return (A)this;
    }

    @Override
    public A withEndpoints(Endpoint ... endpoints) {
        if (this.endpoints != null) {
            this.endpoints.clear();
        }
        if (endpoints != null) {
            for (Endpoint item : endpoints) {
                this.addToEndpoints(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasEndpoints() {
        return this.endpoints != null && !this.endpoints.isEmpty();
    }

    @Override
    public EndpointSliceFluent.EndpointsNested<A> addNewEndpoint() {
        return new EndpointsNestedImpl();
    }

    @Override
    public EndpointSliceFluent.EndpointsNested<A> addNewEndpointLike(Endpoint item) {
        return new EndpointsNestedImpl(-1, item);
    }

    @Override
    public EndpointSliceFluent.EndpointsNested<A> setNewEndpointLike(int index, Endpoint item) {
        return new EndpointsNestedImpl(index, item);
    }

    @Override
    public EndpointSliceFluent.EndpointsNested<A> editEndpoint(int index) {
        if (this.endpoints.size() <= index) {
            throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public EndpointSliceFluent.EndpointsNested<A> editFirstEndpoint() {
        if (this.endpoints.size() == 0) {
            throw new RuntimeException("Can't edit first endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(0, this.buildEndpoint(0));
    }

    @Override
    public EndpointSliceFluent.EndpointsNested<A> editLastEndpoint() {
        int index = this.endpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last endpoints. The list is empty.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public EndpointSliceFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<EndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.endpoints.size(); ++i) {
            if (!predicate.test(this.endpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching endpoints. No match found.");
        }
        return this.setNewEndpointLike(index, this.buildEndpoint(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(int[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(char[] arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2) {
        return this.withKind(new String(arg1, arg2));
    }

    @Override
    public A withNewKind(byte[] arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(char[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withKind(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    @Deprecated
    public ObjectMeta getMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    @Override
    public A withMetadata(ObjectMeta metadata) {
        this._visitables.get("metadata").remove(this.metadata);
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get("metadata").add(this.metadata);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public EndpointSliceFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public EndpointSliceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public EndpointSliceFluent.MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public EndpointSliceFluent.MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : new ObjectMetaBuilder().build());
    }

    @Override
    public EndpointSliceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(this.getMetadata() != null ? this.getMetadata() : item);
    }

    @Override
    public A addToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        this._visitables.get("ports").add(index >= 0 ? index : this._visitables.get("ports").size(), builder);
        this.ports.add(index >= 0 ? index : this.ports.size(), builder);
        return (A)this;
    }

    @Override
    public A setToPorts(int index, EndpointPort item) {
        if (this.ports == null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
        }
        EndpointPortBuilder builder = new EndpointPortBuilder(item);
        if (index < 0 || index >= this._visitables.get("ports").size()) {
            this._visitables.get("ports").add(builder);
        } else {
            this._visitables.get("ports").set(index, builder);
        }
        if (index < 0 || index >= this.ports.size()) {
            this.ports.add(builder);
        } else {
            this.ports.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToPorts(EndpointPort ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<EndpointPort> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
        }
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").add(builder);
            this.ports.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(EndpointPort ... items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<EndpointPort> items) {
        for (EndpointPort item : items) {
            EndpointPortBuilder builder = new EndpointPortBuilder(item);
            this._visitables.get("ports").remove(builder);
            if (this.ports == null) continue;
            this.ports.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromPorts(Predicate<EndpointPortBuilder> predicate) {
        if (this.ports == null) {
            return (A)this;
        }
        Iterator<EndpointPortBuilder> each = this.ports.iterator();
        Object visitables = this._visitables.get("ports");
        while (each.hasNext()) {
            EndpointPortBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<EndpointPort> getPorts() {
        return EndpointSliceFluentImpl.build(this.ports);
    }

    @Override
    public List<EndpointPort> buildPorts() {
        return EndpointSliceFluentImpl.build(this.ports);
    }

    @Override
    public EndpointPort buildPort(int index) {
        return this.ports.get(index).build();
    }

    @Override
    public EndpointPort buildFirstPort() {
        return this.ports.get(0).build();
    }

    @Override
    public EndpointPort buildLastPort() {
        return this.ports.get(this.ports.size() - 1).build();
    }

    @Override
    public EndpointPort buildMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        for (EndpointPortBuilder item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<EndpointPort> ports) {
        if (this.ports != null) {
            this._visitables.get("ports").removeAll(this.ports);
        }
        if (ports != null) {
            this.ports = new ArrayList<EndpointPortBuilder>();
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(EndpointPort ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (EndpointPort item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    @Override
    public A addNewPort(String appProtocol, String name, Integer port, String protocol) {
        return this.addToPorts(new EndpointPort(appProtocol, name, port, protocol));
    }

    @Override
    public EndpointSliceFluent.PortsNested<A> addNewPort() {
        return new PortsNestedImpl();
    }

    @Override
    public EndpointSliceFluent.PortsNested<A> addNewPortLike(EndpointPort item) {
        return new PortsNestedImpl(-1, item);
    }

    @Override
    public EndpointSliceFluent.PortsNested<A> setNewPortLike(int index, EndpointPort item) {
        return new PortsNestedImpl(index, item);
    }

    @Override
    public EndpointSliceFluent.PortsNested<A> editPort(int index) {
        if (this.ports.size() <= index) {
            throw new RuntimeException("Can't edit ports. Index exceeds size.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public EndpointSliceFluent.PortsNested<A> editFirstPort() {
        if (this.ports.size() == 0) {
            throw new RuntimeException("Can't edit first ports. The list is empty.");
        }
        return this.setNewPortLike(0, this.buildPort(0));
    }

    @Override
    public EndpointSliceFluent.PortsNested<A> editLastPort() {
        int index = this.ports.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ports. The list is empty.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    @Override
    public EndpointSliceFluent.PortsNested<A> editMatchingPort(Predicate<EndpointPortBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ports.size(); ++i) {
            if (!predicate.test(this.ports.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ports. No match found.");
        }
        return this.setNewPortLike(index, this.buildPort(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndpointSliceFluentImpl that = (EndpointSliceFluentImpl)o;
        if (this.addressType != null ? !this.addressType.equals(that.addressType) : that.addressType != null) {
            return false;
        }
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.endpoints != null ? !this.endpoints.equals(that.endpoints) : that.endpoints != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        return Objects.hash(this.addressType, this.apiVersion, this.endpoints, this.kind, this.metadata, this.ports, super.hashCode());
    }

    public class PortsNestedImpl<N>
    extends EndpointPortFluentImpl<EndpointSliceFluent.PortsNested<N>>
    implements EndpointSliceFluent.PortsNested<N>,
    Nested<N> {
        private final EndpointPortBuilder builder;
        private final int index;

        PortsNestedImpl(int index, EndpointPort item) {
            this.index = index;
            this.builder = new EndpointPortBuilder(this, item);
        }

        PortsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointPortBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSliceFluentImpl.this.setToPorts(this.index, this.builder.build());
        }

        @Override
        public N endPort() {
            return this.and();
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<EndpointSliceFluent.MetadataNested<N>>
    implements EndpointSliceFluent.MetadataNested<N>,
    Nested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSliceFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }

    public class EndpointsNestedImpl<N>
    extends EndpointFluentImpl<EndpointSliceFluent.EndpointsNested<N>>
    implements EndpointSliceFluent.EndpointsNested<N>,
    Nested<N> {
        private final EndpointBuilder builder;
        private final int index;

        EndpointsNestedImpl(int index, Endpoint item) {
            this.index = index;
            this.builder = new EndpointBuilder(this, item);
        }

        EndpointsNestedImpl() {
            this.index = -1;
            this.builder = new EndpointBuilder(this);
        }

        @Override
        public N and() {
            return (N)EndpointSliceFluentImpl.this.setToEndpoints(this.index, this.builder.build());
        }

        @Override
        public N endEndpoint() {
            return this.and();
        }
    }
}

