/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_3.apps;

import io.fabric8.kubernetes.api.builder.v5_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_3.Nested;
import io.fabric8.kubernetes.api.model.v5_3.apps.StatefulSetCondition;
import io.fabric8.kubernetes.api.model.v5_3.apps.StatefulSetConditionBuilder;
import io.fabric8.kubernetes.api.model.v5_3.apps.StatefulSetConditionFluentImpl;
import io.fabric8.kubernetes.api.model.v5_3.apps.StatefulSetStatus;
import io.fabric8.kubernetes.api.model.v5_3.apps.StatefulSetStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class StatefulSetStatusFluentImpl<A extends StatefulSetStatusFluent<A>>
extends BaseFluent<A>
implements StatefulSetStatusFluent<A> {
    private Integer collisionCount;
    private List<StatefulSetConditionBuilder> conditions = new ArrayList<StatefulSetConditionBuilder>();
    private Integer currentReplicas;
    private String currentRevision;
    private Long observedGeneration;
    private Integer readyReplicas;
    private Integer replicas;
    private String updateRevision;
    private Integer updatedReplicas;

    public StatefulSetStatusFluentImpl() {
    }

    public StatefulSetStatusFluentImpl(StatefulSetStatus instance) {
        this.withCollisionCount(instance.getCollisionCount());
        this.withConditions(instance.getConditions());
        this.withCurrentReplicas(instance.getCurrentReplicas());
        this.withCurrentRevision(instance.getCurrentRevision());
        this.withObservedGeneration(instance.getObservedGeneration());
        this.withReadyReplicas(instance.getReadyReplicas());
        this.withReplicas(instance.getReplicas());
        this.withUpdateRevision(instance.getUpdateRevision());
        this.withUpdatedReplicas(instance.getUpdatedReplicas());
    }

    @Override
    public Integer getCollisionCount() {
        return this.collisionCount;
    }

    @Override
    public A withCollisionCount(Integer collisionCount) {
        this.collisionCount = collisionCount;
        return (A)this;
    }

    @Override
    public Boolean hasCollisionCount() {
        return this.collisionCount != null;
    }

    @Override
    public A withNewCollisionCount(int arg0) {
        return this.withCollisionCount(new Integer(arg0));
    }

    @Override
    public A addToConditions(int index, StatefulSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<StatefulSetConditionBuilder>();
        }
        StatefulSetConditionBuilder builder = new StatefulSetConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, StatefulSetCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<StatefulSetConditionBuilder>();
        }
        StatefulSetConditionBuilder builder = new StatefulSetConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(StatefulSetCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<StatefulSetConditionBuilder>();
        }
        for (StatefulSetCondition item : items) {
            StatefulSetConditionBuilder builder = new StatefulSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<StatefulSetCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<StatefulSetConditionBuilder>();
        }
        for (StatefulSetCondition item : items) {
            StatefulSetConditionBuilder builder = new StatefulSetConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(StatefulSetCondition ... items) {
        for (StatefulSetCondition item : items) {
            StatefulSetConditionBuilder builder = new StatefulSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<StatefulSetCondition> items) {
        for (StatefulSetCondition item : items) {
            StatefulSetConditionBuilder builder = new StatefulSetConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<StatefulSetConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<StatefulSetConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            StatefulSetConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<StatefulSetCondition> getConditions() {
        return StatefulSetStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<StatefulSetCondition> buildConditions() {
        return StatefulSetStatusFluentImpl.build(this.conditions);
    }

    @Override
    public StatefulSetCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public StatefulSetCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public StatefulSetCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public StatefulSetCondition buildMatchingCondition(Predicate<StatefulSetConditionBuilder> predicate) {
        for (StatefulSetConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<StatefulSetConditionBuilder> predicate) {
        for (StatefulSetConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<StatefulSetCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<StatefulSetConditionBuilder>();
            for (StatefulSetCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(StatefulSetCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (StatefulSetCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new StatefulSetCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public StatefulSetStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public StatefulSetStatusFluent.ConditionsNested<A> addNewConditionLike(StatefulSetCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public StatefulSetStatusFluent.ConditionsNested<A> setNewConditionLike(int index, StatefulSetCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public StatefulSetStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public StatefulSetStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public StatefulSetStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public StatefulSetStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<StatefulSetConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public Integer getCurrentReplicas() {
        return this.currentReplicas;
    }

    @Override
    public A withCurrentReplicas(Integer currentReplicas) {
        this.currentReplicas = currentReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentReplicas() {
        return this.currentReplicas != null;
    }

    @Override
    public A withNewCurrentReplicas(int arg0) {
        return this.withCurrentReplicas(new Integer(arg0));
    }

    @Override
    public String getCurrentRevision() {
        return this.currentRevision;
    }

    @Override
    public A withCurrentRevision(String currentRevision) {
        this.currentRevision = currentRevision;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentRevision() {
        return this.currentRevision != null;
    }

    @Override
    public A withNewCurrentRevision(StringBuilder arg1) {
        return this.withCurrentRevision(new String(arg1));
    }

    @Override
    public A withNewCurrentRevision(int[] arg1, int arg2, int arg3) {
        return this.withCurrentRevision(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewCurrentRevision(char[] arg1) {
        return this.withCurrentRevision(new String(arg1));
    }

    @Override
    public A withNewCurrentRevision(StringBuffer arg1) {
        return this.withCurrentRevision(new String(arg1));
    }

    @Override
    public A withNewCurrentRevision(byte[] arg1, int arg2) {
        return this.withCurrentRevision(new String(arg1, arg2));
    }

    @Override
    public A withNewCurrentRevision(byte[] arg1) {
        return this.withCurrentRevision(new String(arg1));
    }

    @Override
    public A withNewCurrentRevision(char[] arg1, int arg2, int arg3) {
        return this.withCurrentRevision(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewCurrentRevision(byte[] arg1, int arg2, int arg3) {
        return this.withCurrentRevision(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewCurrentRevision(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withCurrentRevision(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewCurrentRevision(String arg1) {
        return this.withCurrentRevision(new String(arg1));
    }

    @Override
    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    @Override
    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)this;
    }

    @Override
    public Boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    @Override
    public A withNewObservedGeneration(long arg1) {
        return this.withObservedGeneration(new Long(arg1));
    }

    @Override
    public Integer getReadyReplicas() {
        return this.readyReplicas;
    }

    @Override
    public A withReadyReplicas(Integer readyReplicas) {
        this.readyReplicas = readyReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasReadyReplicas() {
        return this.readyReplicas != null;
    }

    @Override
    public A withNewReadyReplicas(int arg0) {
        return this.withReadyReplicas(new Integer(arg0));
    }

    @Override
    public Integer getReplicas() {
        return this.replicas;
    }

    @Override
    public A withReplicas(Integer replicas) {
        this.replicas = replicas;
        return (A)this;
    }

    @Override
    public Boolean hasReplicas() {
        return this.replicas != null;
    }

    @Override
    public A withNewReplicas(int arg0) {
        return this.withReplicas(new Integer(arg0));
    }

    @Override
    public String getUpdateRevision() {
        return this.updateRevision;
    }

    @Override
    public A withUpdateRevision(String updateRevision) {
        this.updateRevision = updateRevision;
        return (A)this;
    }

    @Override
    public Boolean hasUpdateRevision() {
        return this.updateRevision != null;
    }

    @Override
    public A withNewUpdateRevision(StringBuilder arg1) {
        return this.withUpdateRevision(new String(arg1));
    }

    @Override
    public A withNewUpdateRevision(int[] arg1, int arg2, int arg3) {
        return this.withUpdateRevision(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUpdateRevision(char[] arg1) {
        return this.withUpdateRevision(new String(arg1));
    }

    @Override
    public A withNewUpdateRevision(StringBuffer arg1) {
        return this.withUpdateRevision(new String(arg1));
    }

    @Override
    public A withNewUpdateRevision(byte[] arg1, int arg2) {
        return this.withUpdateRevision(new String(arg1, arg2));
    }

    @Override
    public A withNewUpdateRevision(byte[] arg1) {
        return this.withUpdateRevision(new String(arg1));
    }

    @Override
    public A withNewUpdateRevision(char[] arg1, int arg2, int arg3) {
        return this.withUpdateRevision(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUpdateRevision(byte[] arg1, int arg2, int arg3) {
        return this.withUpdateRevision(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewUpdateRevision(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withUpdateRevision(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewUpdateRevision(String arg1) {
        return this.withUpdateRevision(new String(arg1));
    }

    @Override
    public Integer getUpdatedReplicas() {
        return this.updatedReplicas;
    }

    @Override
    public A withUpdatedReplicas(Integer updatedReplicas) {
        this.updatedReplicas = updatedReplicas;
        return (A)this;
    }

    @Override
    public Boolean hasUpdatedReplicas() {
        return this.updatedReplicas != null;
    }

    @Override
    public A withNewUpdatedReplicas(int arg0) {
        return this.withUpdatedReplicas(new Integer(arg0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatefulSetStatusFluentImpl that = (StatefulSetStatusFluentImpl)o;
        if (this.collisionCount != null ? !this.collisionCount.equals(that.collisionCount) : that.collisionCount != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.currentReplicas != null ? !this.currentReplicas.equals(that.currentReplicas) : that.currentReplicas != null) {
            return false;
        }
        if (this.currentRevision != null ? !this.currentRevision.equals(that.currentRevision) : that.currentRevision != null) {
            return false;
        }
        if (this.observedGeneration != null ? !this.observedGeneration.equals(that.observedGeneration) : that.observedGeneration != null) {
            return false;
        }
        if (this.readyReplicas != null ? !this.readyReplicas.equals(that.readyReplicas) : that.readyReplicas != null) {
            return false;
        }
        if (this.replicas != null ? !this.replicas.equals(that.replicas) : that.replicas != null) {
            return false;
        }
        if (this.updateRevision != null ? !this.updateRevision.equals(that.updateRevision) : that.updateRevision != null) {
            return false;
        }
        return !(this.updatedReplicas != null ? !this.updatedReplicas.equals(that.updatedReplicas) : that.updatedReplicas != null);
    }

    public int hashCode() {
        return Objects.hash(this.collisionCount, this.conditions, this.currentReplicas, this.currentRevision, this.observedGeneration, this.readyReplicas, this.replicas, this.updateRevision, this.updatedReplicas, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends StatefulSetConditionFluentImpl<StatefulSetStatusFluent.ConditionsNested<N>>
    implements StatefulSetStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final StatefulSetConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, StatefulSetCondition item) {
            this.index = index;
            this.builder = new StatefulSetConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new StatefulSetConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)StatefulSetStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

