/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_3;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.Pluralize;
import io.fabric8.kubernetes.api.model.v5_3.KubernetesResource;
import io.fabric8.kubernetes.api.model.v5_3.ObjectMeta;
import io.fabric8.kubernetes.model.annotation.Group;
import io.fabric8.kubernetes.model.annotation.Kind;
import io.fabric8.kubernetes.model.annotation.Plural;
import io.fabric8.kubernetes.model.annotation.Singular;
import io.fabric8.kubernetes.model.annotation.Version;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface HasMetadata
extends KubernetesResource {
    public static final String DNS_LABEL_START = "(?!-)[A-Za-z0-9-]{";
    public static final String DNS_LABEL_END = ",63}(?<!-)";
    public static final String DNS_LABEL_REGEXP = "(?!-)[A-Za-z0-9-]{1,63}(?<!-)";
    public static final Pattern FINALIZER_NAME_MATCHER = Pattern.compile("^(((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+(?!-)[A-Za-z0-9-]{2,63}(?<!-))/(?!-)[A-Za-z0-9-]{1,63}(?<!-)");

    public ObjectMeta getMetadata();

    public void setMetadata(ObjectMeta var1);

    public static String getKind(Class<?> clazz) {
        Kind kind = clazz.getAnnotation(Kind.class);
        return kind != null ? kind.value() : clazz.getSimpleName();
    }

    default public String getKind() {
        return HasMetadata.getKind(this.getClass());
    }

    public static String getApiVersion(Class<?> clazz) {
        String group = HasMetadata.getGroup(clazz);
        String version = HasMetadata.getVersion(clazz);
        if (group != null && version != null) {
            return group + "/" + version;
        }
        if (group != null || version != null) {
            throw new IllegalArgumentException("You need to specify both @" + Group.class.getSimpleName() + " and @" + Version.class.getSimpleName() + " annotations if you specify either");
        }
        return null;
    }

    public static String getGroup(Class<?> clazz) {
        Group group = clazz.getAnnotation(Group.class);
        return group != null ? group.value() : null;
    }

    public static String getVersion(Class<?> clazz) {
        Version version = clazz.getAnnotation(Version.class);
        return version != null ? version.value() : null;
    }

    default public String getApiVersion() {
        return HasMetadata.getApiVersion(this.getClass());
    }

    public void setApiVersion(String var1);

    public static String getPlural(Class<?> clazz) {
        Plural fromAnnotation = clazz.getAnnotation(Plural.class);
        return fromAnnotation != null ? fromAnnotation.value().toLowerCase(Locale.ROOT) : Pluralize.toPlural(HasMetadata.getSingular(clazz));
    }

    @JsonIgnore
    default public String getPlural() {
        return HasMetadata.getPlural(this.getClass());
    }

    public static String getSingular(Class<?> clazz) {
        Singular fromAnnotation = clazz.getAnnotation(Singular.class);
        return (fromAnnotation != null ? fromAnnotation.value() : HasMetadata.getKind(clazz)).toLowerCase(Locale.ROOT);
    }

    @JsonIgnore
    default public String getSingular() {
        return HasMetadata.getSingular(this.getClass());
    }

    @JsonIgnore
    default public boolean isMarkedForDeletion() {
        String deletionTimestamp = this.getMetadata().getDeletionTimestamp();
        return deletionTimestamp != null && !deletionTimestamp.isEmpty();
    }

    default public boolean hasFinalizer(String finalizer) {
        return this.getMetadata().getFinalizers().contains(finalizer);
    }

    default public boolean addFinalizer(String finalizer) {
        if (finalizer == null || finalizer.trim().isEmpty()) {
            throw new IllegalArgumentException("Must pass a non-null, non-blank finalizer.");
        }
        if (this.isMarkedForDeletion() || this.hasFinalizer(finalizer)) {
            return false;
        }
        if (this.isFinalizerValid(finalizer)) {
            return this.getMetadata().getFinalizers().add(finalizer);
        }
        throw new IllegalArgumentException("Invalid finalizer name: '" + finalizer + "'. Must consist of a domain name, a forward slash and the valid kubernetes name.");
    }

    default public boolean isFinalizerValid(String finalizer) {
        if (finalizer == null) {
            return false;
        }
        Matcher matcher = FINALIZER_NAME_MATCHER.matcher(finalizer);
        if (matcher.matches()) {
            String group = matcher.group(1);
            return group.length() < 256;
        }
        return false;
    }

    default public boolean removeFinalizer(String finalizer) {
        return this.getMetadata().getFinalizers().remove(finalizer);
    }
}

