/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.rbac;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBinding;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingBuilder;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingFluentImpl;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingList;
import io.fabric8.kubernetes.api.model.rbac.ClusterRoleBindingListFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ClusterRoleBindingListFluentImpl<A extends ClusterRoleBindingListFluent<A>>
extends BaseFluent<A>
implements ClusterRoleBindingListFluent<A> {
    private String apiVersion;
    private List<ClusterRoleBindingBuilder> items = new ArrayList<ClusterRoleBindingBuilder>();
    private String kind;
    private ListMeta metadata;

    public ClusterRoleBindingListFluentImpl() {
    }

    public ClusterRoleBindingListFluentImpl(ClusterRoleBindingList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A withNewApiVersion(StringBuilder arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(int[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(char[] arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(StringBuffer arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2) {
        return this.withApiVersion(new String(arg1, arg2));
    }

    @Override
    public A withNewApiVersion(byte[] arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A withNewApiVersion(char[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2, int arg3) {
        return this.withApiVersion(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewApiVersion(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewApiVersion(String arg1) {
        return this.withApiVersion(new String(arg1));
    }

    @Override
    public A addToItems(int index, ClusterRoleBinding item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterRoleBindingBuilder>();
        }
        ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
        this._visitables.get("items").add(index >= 0 ? index : this._visitables.get("items").size(), builder);
        this.items.add(index >= 0 ? index : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(int index, ClusterRoleBinding item) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterRoleBindingBuilder>();
        }
        ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
        if (index < 0 || index >= this._visitables.get("items").size()) {
            this._visitables.get("items").add(builder);
        } else {
            this._visitables.get("items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ClusterRoleBinding ... items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterRoleBindingBuilder>();
        }
        for (ClusterRoleBinding item : items) {
            ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ClusterRoleBinding> items) {
        if (this.items == null) {
            this.items = new ArrayList<ClusterRoleBindingBuilder>();
        }
        for (ClusterRoleBinding item : items) {
            ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
            this._visitables.get("items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ClusterRoleBinding ... items) {
        for (ClusterRoleBinding item : items) {
            ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ClusterRoleBinding> items) {
        for (ClusterRoleBinding item : items) {
            ClusterRoleBindingBuilder builder = new ClusterRoleBindingBuilder(item);
            this._visitables.get("items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ClusterRoleBindingBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ClusterRoleBindingBuilder> each = this.items.iterator();
        Object visitables = this._visitables.get("items");
        while (each.hasNext()) {
            ClusterRoleBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ClusterRoleBinding> getItems() {
        return ClusterRoleBindingListFluentImpl.build(this.items);
    }

    @Override
    public List<ClusterRoleBinding> buildItems() {
        return ClusterRoleBindingListFluentImpl.build(this.items);
    }

    @Override
    public ClusterRoleBinding buildItem(int index) {
        return this.items.get(index).build();
    }

    @Override
    public ClusterRoleBinding buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ClusterRoleBinding buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ClusterRoleBinding buildMatchingItem(Predicate<ClusterRoleBindingBuilder> predicate) {
        for (ClusterRoleBindingBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ClusterRoleBindingBuilder> predicate) {
        for (ClusterRoleBindingBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ClusterRoleBinding> items) {
        if (this.items != null) {
            this._visitables.get("items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList<ClusterRoleBindingBuilder>();
            for (ClusterRoleBinding item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ClusterRoleBinding ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ClusterRoleBinding item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ClusterRoleBindingListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ClusterRoleBindingListFluent.ItemsNested<A> addNewItemLike(ClusterRoleBinding item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ClusterRoleBindingListFluent.ItemsNested<A> setNewItemLike(int index, ClusterRoleBinding item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ClusterRoleBindingListFluent.ItemsNested<A> editItem(int index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterRoleBindingListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ClusterRoleBindingListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ClusterRoleBindingListFluent.ItemsNested<A> editMatchingItem(Predicate<ClusterRoleBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public A withNewKind(StringBuilder arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(int[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(char[] arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(StringBuffer arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2) {
        return this.withKind(new String(arg1, arg2));
    }

    @Override
    public A withNewKind(byte[] arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public A withNewKind(char[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2, int arg3) {
        return this.withKind(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewKind(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withKind(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewKind(String arg1) {
        return this.withKind(new String(arg1));
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterRoleBindingListFluentImpl that = (ClusterRoleBindingListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public class ItemsNestedImpl<N>
    extends ClusterRoleBindingFluentImpl<ClusterRoleBindingListFluent.ItemsNested<N>>
    implements ClusterRoleBindingListFluent.ItemsNested<N>,
    Nested<N> {
        private final ClusterRoleBindingBuilder builder;
        private final int index;

        ItemsNestedImpl(int index, ClusterRoleBinding item) {
            this.index = index;
            this.builder = new ClusterRoleBindingBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ClusterRoleBindingBuilder(this);
        }

        @Override
        public N and() {
            return (N)ClusterRoleBindingListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

