/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_3.handlers;

import io.fabric8.kubernetes.api.model.v5_3.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_3.ListOptions;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_3.Watch;
import io.fabric8.kubernetes.clnt.v5_3.Watcher;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.WritableOperation;
import io.fabric8.openshift.api.model.v5_3.operator.v1.Network;
import io.fabric8.openshift.api.model.v5_3.operator.v1.NetworkBuilder;
import io.fabric8.openshift.clnt.v5_3.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.NetworkOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class NetworkHandler
implements ResourceHandler<Network, NetworkBuilder> {
    @Override
    public String getKind() {
        return Network.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "operator.openshift.io/v1";
    }

    @Override
    public Network create(OkHttpClient client, Config config, String namespace, Network item, boolean dryRun) {
        return (Network)((WritableOperation)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Network[0]);
    }

    @Override
    public Network replace(OkHttpClient client, Config config, String namespace, Network item, boolean dryRun) {
        return ((WritableOperation)((Resource)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Network reload(OkHttpClient client, Config config, String namespace, Network item) {
        return (Network)((Gettable)((Resource)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public NetworkBuilder edit(Network item) {
        return new NetworkBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Network item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Network item, Watcher<Network> watcher) {
        return ((Resource)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Network item, String resourceVersion, Watcher<Network> watcher) {
        return ((Resource)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Network item, ListOptions options, Watcher<Network> watcher) {
        return ((Resource)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Network waitUntilReady(OkHttpClient client, Config config, String namespace, Network item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Network)((Resource)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Network waitUntilCondition(OkHttpClient client, Config config, String namespace, Network item, Predicate<Network> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Network)((Resource)new NetworkOperationsImpl(client, OpenShiftConfig.wrap(config)).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

