/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.clnt.v5_3;

import io.fabric8.kubernetes.api.model.v5_3.APIService;
import io.fabric8.kubernetes.api.model.v5_3.APIServiceList;
import io.fabric8.kubernetes.api.model.v5_3.Binding;
import io.fabric8.kubernetes.api.model.v5_3.ComponentStatus;
import io.fabric8.kubernetes.api.model.v5_3.ComponentStatusList;
import io.fabric8.kubernetes.api.model.v5_3.ConfigMap;
import io.fabric8.kubernetes.api.model.v5_3.ConfigMapList;
import io.fabric8.kubernetes.api.model.v5_3.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_3.Endpoints;
import io.fabric8.kubernetes.api.model.v5_3.EndpointsList;
import io.fabric8.kubernetes.api.model.v5_3.HasMetadata;
import io.fabric8.kubernetes.api.model.v5_3.KubernetesList;
import io.fabric8.kubernetes.api.model.v5_3.KubernetesListBuilder;
import io.fabric8.kubernetes.api.model.v5_3.KubernetesResourceList;
import io.fabric8.kubernetes.api.model.v5_3.LimitRange;
import io.fabric8.kubernetes.api.model.v5_3.LimitRangeList;
import io.fabric8.kubernetes.api.model.v5_3.Namespace;
import io.fabric8.kubernetes.api.model.v5_3.NamespaceList;
import io.fabric8.kubernetes.api.model.v5_3.Node;
import io.fabric8.kubernetes.api.model.v5_3.NodeList;
import io.fabric8.kubernetes.api.model.v5_3.PersistentVolume;
import io.fabric8.kubernetes.api.model.v5_3.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.v5_3.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.v5_3.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.v5_3.Pod;
import io.fabric8.kubernetes.api.model.v5_3.PodList;
import io.fabric8.kubernetes.api.model.v5_3.ReplicationController;
import io.fabric8.kubernetes.api.model.v5_3.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.v5_3.ResourceQuota;
import io.fabric8.kubernetes.api.model.v5_3.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.v5_3.RootPaths;
import io.fabric8.kubernetes.api.model.v5_3.Secret;
import io.fabric8.kubernetes.api.model.v5_3.SecretList;
import io.fabric8.kubernetes.api.model.v5_3.Service;
import io.fabric8.kubernetes.api.model.v5_3.ServiceAccount;
import io.fabric8.kubernetes.api.model.v5_3.ServiceAccountList;
import io.fabric8.kubernetes.api.model.v5_3.ServiceList;
import io.fabric8.kubernetes.api.model.v5_3.authentication.TokenReview;
import io.fabric8.kubernetes.api.model.v5_3.certificates.v1beta1.CertificateSigningRequest;
import io.fabric8.kubernetes.api.model.v5_3.certificates.v1beta1.CertificateSigningRequestList;
import io.fabric8.kubernetes.api.model.v5_3.coordination.v1.Lease;
import io.fabric8.kubernetes.api.model.v5_3.coordination.v1.LeaseList;
import io.fabric8.kubernetes.api.model.v5_3.node.v1beta1.RuntimeClass;
import io.fabric8.kubernetes.api.model.v5_3.node.v1beta1.RuntimeClassList;
import io.fabric8.kubernetes.clnt.v5_3.AdmissionRegistrationAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.AdmissionRegistrationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.AppsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.AutoscalingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.BaseClient;
import io.fabric8.kubernetes.clnt.v5_3.BatchAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.CustomResource;
import io.fabric8.kubernetes.clnt.v5_3.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_3.ExtensionsAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_3.MetricAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.NamespacedKubernetesClient;
import io.fabric8.kubernetes.clnt.v5_3.NetworkAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.PolicyAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.RbacAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.RequestConfig;
import io.fabric8.kubernetes.clnt.v5_3.SchedulingAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.StorageAPIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.V1APIGroupClient;
import io.fabric8.kubernetes.clnt.v5_3.VersionInfo;
import io.fabric8.kubernetes.clnt.v5_3.WithRequestCallable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.ApiextensionsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.AppsAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.AuthorizationAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.AutoscalingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.BatchAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.CertificatesAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Createable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.DiscoveryAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.EventingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.FunctionCallable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.InOutCreateable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.KubernetesListMixedOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_3.dsl.MetricAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.MixedOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.NetworkAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.ParameterMixedOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.PodResource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.PolicyAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.RbacAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.SchedulingAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.ServiceResource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.StorageAPIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.V1APIGroupDSL;
import io.fabric8.kubernetes.clnt.v5_3.dsl.base.CustomResourceDefinitionContext;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.CustomResourceOperationContext;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.CustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.RawCustomResourceOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.coordination.v1.LeaseOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.core.v1.ComponentStatusOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_3.extended.leaderelection.LeaderElectorBuilder;
import io.fabric8.kubernetes.clnt.v5_3.extended.run.RunConfigBuilder;
import io.fabric8.kubernetes.clnt.v5_3.extended.run.RunOperations;
import io.fabric8.kubernetes.clnt.v5_3.informers.SharedInformerFactory;
import io.fabric8.kubernetes.clnt.v5_3.utils.BackwardsCompatibilityInterceptor;
import io.fabric8.kubernetes.clnt.v5_3.utils.ImpersonatorInterceptor;
import io.fabric8.kubernetes.clnt.v5_3.utils.Serialization;
import io.fabric8.openshift.api.model.v5_3.Build;
import io.fabric8.openshift.api.model.v5_3.BuildConfig;
import io.fabric8.openshift.api.model.v5_3.BuildConfigList;
import io.fabric8.openshift.api.model.v5_3.BuildList;
import io.fabric8.openshift.api.model.v5_3.ClusterNetwork;
import io.fabric8.openshift.api.model.v5_3.ClusterNetworkList;
import io.fabric8.openshift.api.model.v5_3.ClusterRoleBinding;
import io.fabric8.openshift.api.model.v5_3.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.v5_3.DeploymentConfig;
import io.fabric8.openshift.api.model.v5_3.DeploymentConfigList;
import io.fabric8.openshift.api.model.v5_3.EgressNetworkPolicy;
import io.fabric8.openshift.api.model.v5_3.EgressNetworkPolicyList;
import io.fabric8.openshift.api.model.v5_3.Group;
import io.fabric8.openshift.api.model.v5_3.GroupList;
import io.fabric8.openshift.api.model.v5_3.Image;
import io.fabric8.openshift.api.model.v5_3.ImageList;
import io.fabric8.openshift.api.model.v5_3.ImageStream;
import io.fabric8.openshift.api.model.v5_3.ImageStreamList;
import io.fabric8.openshift.api.model.v5_3.ImageStreamTag;
import io.fabric8.openshift.api.model.v5_3.ImageStreamTagList;
import io.fabric8.openshift.api.model.v5_3.ImageTag;
import io.fabric8.openshift.api.model.v5_3.ImageTagList;
import io.fabric8.openshift.api.model.v5_3.LocalSubjectAccessReview;
import io.fabric8.openshift.api.model.v5_3.NetNamespace;
import io.fabric8.openshift.api.model.v5_3.NetNamespaceList;
import io.fabric8.openshift.api.model.v5_3.OAuthAccessToken;
import io.fabric8.openshift.api.model.v5_3.OAuthAccessTokenList;
import io.fabric8.openshift.api.model.v5_3.OAuthAuthorizeToken;
import io.fabric8.openshift.api.model.v5_3.OAuthAuthorizeTokenList;
import io.fabric8.openshift.api.model.v5_3.OAuthClient;
import io.fabric8.openshift.api.model.v5_3.OAuthClientList;
import io.fabric8.openshift.api.model.v5_3.RangeAllocation;
import io.fabric8.openshift.api.model.v5_3.RangeAllocationList;
import io.fabric8.openshift.api.model.v5_3.Role;
import io.fabric8.openshift.api.model.v5_3.RoleBinding;
import io.fabric8.openshift.api.model.v5_3.RoleBindingList;
import io.fabric8.openshift.api.model.v5_3.RoleList;
import io.fabric8.openshift.api.model.v5_3.Route;
import io.fabric8.openshift.api.model.v5_3.RouteList;
import io.fabric8.openshift.api.model.v5_3.SecurityContextConstraints;
import io.fabric8.openshift.api.model.v5_3.SecurityContextConstraintsList;
import io.fabric8.openshift.api.model.v5_3.SubjectAccessReview;
import io.fabric8.openshift.api.model.v5_3.SubjectAccessReviewResponse;
import io.fabric8.openshift.api.model.v5_3.Template;
import io.fabric8.openshift.api.model.v5_3.TemplateList;
import io.fabric8.openshift.api.model.v5_3.User;
import io.fabric8.openshift.api.model.v5_3.UserList;
import io.fabric8.openshift.clnt.v5_3.NamespacedOpenShiftClient;
import io.fabric8.openshift.clnt.v5_3.OpenShiftConfig;
import io.fabric8.openshift.clnt.v5_3.OpenShiftConfigAPIGroupClient;
import io.fabric8.openshift.clnt.v5_3.OpenShiftConfigBuilder;
import io.fabric8.openshift.clnt.v5_3.OpenShiftConsoleAPIGroupClient;
import io.fabric8.openshift.clnt.v5_3.OpenShiftLocalSubjectAccessReviewOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.OpenShiftMonitoringAPIGroupClient;
import io.fabric8.openshift.clnt.v5_3.OpenShiftOperatorAPIGroupClient;
import io.fabric8.openshift.clnt.v5_3.OpenShiftOperatorHubAPIGroupClient;
import io.fabric8.openshift.clnt.v5_3.OpenShiftQuotaAPIGroupClient;
import io.fabric8.openshift.clnt.v5_3.OpenshiftAdapterSupport;
import io.fabric8.openshift.clnt.v5_3.dsl.BuildConfigResource;
import io.fabric8.openshift.clnt.v5_3.dsl.BuildResource;
import io.fabric8.openshift.clnt.v5_3.dsl.DeployableScalableResource;
import io.fabric8.openshift.clnt.v5_3.dsl.OpenShiftConfigAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_3.dsl.OpenShiftConsoleAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_3.dsl.OpenShiftMonitoringAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_3.dsl.OpenShiftOperatorAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_3.dsl.OpenShiftOperatorHubAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_3.dsl.OpenShiftQuotaAPIGroupDSL;
import io.fabric8.openshift.clnt.v5_3.dsl.ProjectOperation;
import io.fabric8.openshift.clnt.v5_3.dsl.ProjectRequestOperation;
import io.fabric8.openshift.clnt.v5_3.dsl.TemplateResource;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.BuildConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.BuildOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.ClusterNetworkOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.ClusterRoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.DeploymentConfigOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.EgressNetworkPolicyOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.GroupOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.ImageOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.ImageStreamOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.ImageStreamTagOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.ImageTagOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.NetNamespaceOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.OAuthAccessTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.OAuthAuthorizeTokenOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.OAuthClientOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.OpenShiftSubjectAccessReviewOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.ProjectOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.ProjectRequestsOperationImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.RangeAllocationOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.RoleBindingOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.RoleOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.RouteOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.SecurityContextConstraintsOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.TemplateOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.dsl.internal.UserOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.internal.OpenShiftClusterOperationsImpl;
import io.fabric8.openshift.clnt.v5_3.internal.OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl;
import io.fabric8.openshift.clnt.v5_3.internal.OpenShiftOAuthInterceptor;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;

public class DefaultOpenShiftClient
extends BaseClient
implements NamespacedOpenShiftClient {
    private static final Map<String, Boolean> API_GROUPS_ENABLED_PER_URL = new HashMap<String, Boolean>();
    private final URL openShiftUrl;
    private final NamespacedKubernetesClient delegate;

    public DefaultOpenShiftClient() {
        this(new OpenShiftConfigBuilder().build());
    }

    public DefaultOpenShiftClient(String masterUrl) {
        this(((OpenShiftConfigBuilder)new OpenShiftConfigBuilder().withMasterUrl(masterUrl)).build());
    }

    public DefaultOpenShiftClient(Config config) {
        this(new OpenShiftConfig(config));
    }

    public DefaultOpenShiftClient(OpenShiftConfig config) {
        super(DefaultOpenShiftClient.configWithApiGroupsEnabled(DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(config), config));
        try {
            this.httpClient = DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(this.httpClient, config);
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    public DefaultOpenShiftClient(OkHttpClient httpClient, OpenShiftConfig config) {
        super(httpClient, DefaultOpenShiftClient.configWithApiGroupsEnabled(httpClient, config));
        try {
            this.httpClient = DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(httpClient, this.getConfiguration());
            this.delegate = new DefaultKubernetesClient(this.httpClient, config);
            this.openShiftUrl = new URL(config.getOpenShiftUrl());
        }
        catch (MalformedURLException e) {
            throw new KubernetesClientException("Could not create client", e);
        }
    }

    private static OpenShiftConfig configWithApiGroupsEnabled(OkHttpClient httpClient, OpenShiftConfig config) {
        String url = config.getMasterUrl();
        Boolean openshiftApiGroupsEnabled = API_GROUPS_ENABLED_PER_URL.containsKey(url);
        if (openshiftApiGroupsEnabled.booleanValue()) {
            return config;
        }
        if (!config.isDisableApiGroupCheck()) {
            return config.withOpenshiftApiGroupsEnabled(false);
        }
        Boolean enabled = OpenshiftAdapterSupport.isOpenShiftAPIGroups(httpClient, url);
        API_GROUPS_ENABLED_PER_URL.put(url, enabled);
        return config.withOpenshiftApiGroupsEnabled(enabled);
    }

    public static DefaultOpenShiftClient fromConfig(String config) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(config, OpenShiftConfig.class));
    }

    public static DefaultOpenShiftClient fromConfig(InputStream is) {
        return new DefaultOpenShiftClient(Serialization.unmarshal(is, OpenShiftConfig.class));
    }

    private static OkHttpClient clientWithOpenShiftOAuthInterceptor(Config config) {
        return DefaultOpenShiftClient.clientWithOpenShiftOAuthInterceptor(null, config);
    }

    static OkHttpClient clientWithOpenShiftOAuthInterceptor(OkHttpClient httpClient, Config config) {
        OkHttpClient.Builder builder = httpClient != null ? httpClient.newBuilder().authenticator(Authenticator.NONE) : new OkHttpClient.Builder().authenticator(Authenticator.NONE);
        builder.interceptors().clear();
        return builder.addInterceptor((Interceptor)new OpenShiftOAuthInterceptor(httpClient, OpenShiftConfig.wrap(config))).addInterceptor((Interceptor)new ImpersonatorInterceptor(config)).addInterceptor((Interceptor)new BackwardsCompatibilityInterceptor()).build();
    }

    @Override
    public URL getOpenshiftUrl() {
        return this.openShiftUrl;
    }

    @Override
    public OpenShiftConfigAPIGroupDSL config() {
        return this.adapt(OpenShiftConfigAPIGroupClient.class);
    }

    @Override
    public OpenShiftConsoleAPIGroupDSL console() {
        return this.adapt(OpenShiftConsoleAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorAPIGroupDSL operator() {
        return this.adapt(OpenShiftOperatorAPIGroupClient.class);
    }

    @Override
    public OpenShiftOperatorHubAPIGroupDSL operatorHub() {
        return this.adapt(OpenShiftOperatorHubAPIGroupClient.class);
    }

    @Override
    public MixedOperation<ComponentStatus, ComponentStatusList, Resource<ComponentStatus>> componentstatuses() {
        return new ComponentStatusOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> load(InputStream is) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), is, null, true, DeletionPropagation.BACKGROUND, false){};
    }

    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(HasMetadata item) {
        return this.delegate.resource(item);
    }

    @Override
    public NamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicable<HasMetadata> resource(String s) {
        return this.delegate.resource(s);
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(KubernetesResourceList item) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), item, null, DeletionPropagation.BACKGROUND, true, false){};
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(HasMetadata ... items) {
        return this.resourceList(((KubernetesListBuilder)new KubernetesListBuilder().withItems(items)).build());
    }

    @Override
    public NamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(Collection<HasMetadata> items) {
        return this.delegate.resourceList(items);
    }

    @Override
    public ParameterNamespaceListVisitFromServerGetDeleteRecreateWaitApplicable<HasMetadata> resourceList(String s) {
        return new OpenShiftNamespaceVisitFromServerGetWatchDeleteRecreateWaitApplicableListImpl(this.httpClient, this.getConfiguration(), this.getNamespace(), null, false, false, new ArrayList(), s, null, DeletionPropagation.BACKGROUND, true, false){};
    }

    @Override
    public MixedOperation<Endpoints, EndpointsList, Resource<Endpoints>> endpoints() {
        return this.delegate.endpoints();
    }

    @Override
    public MixedOperation<Binding, KubernetesResourceList<Binding>, Resource<Binding>> bindings() {
        return this.delegate.bindings();
    }

    @Override
    public NonNamespaceOperation<Namespace, NamespaceList, Resource<Namespace>> namespaces() {
        return this.delegate.namespaces();
    }

    @Override
    public NonNamespaceOperation<Node, NodeList, Resource<Node>> nodes() {
        return this.delegate.nodes();
    }

    @Override
    public NonNamespaceOperation<PersistentVolume, PersistentVolumeList, Resource<PersistentVolume>> persistentVolumes() {
        return this.delegate.persistentVolumes();
    }

    @Override
    public MixedOperation<PersistentVolumeClaim, PersistentVolumeClaimList, Resource<PersistentVolumeClaim>> persistentVolumeClaims() {
        return this.delegate.persistentVolumeClaims();
    }

    @Override
    public MixedOperation<Pod, PodList, PodResource<Pod>> pods() {
        return this.delegate.pods();
    }

    @Override
    public MixedOperation<ReplicationController, ReplicationControllerList, RollableScalableResource<ReplicationController>> replicationControllers() {
        return this.delegate.replicationControllers();
    }

    @Override
    public MixedOperation<ResourceQuota, ResourceQuotaList, Resource<ResourceQuota>> resourceQuotas() {
        return this.delegate.resourceQuotas();
    }

    @Override
    public MixedOperation<Secret, SecretList, Resource<Secret>> secrets() {
        return this.delegate.secrets();
    }

    @Override
    public MixedOperation<Service, ServiceList, ServiceResource<Service>> services() {
        return this.delegate.services();
    }

    @Override
    public MixedOperation<ServiceAccount, ServiceAccountList, Resource<ServiceAccount>> serviceAccounts() {
        return this.delegate.serviceAccounts();
    }

    @Override
    public MixedOperation<APIService, APIServiceList, Resource<APIService>> apiServices() {
        return this.delegate.apiServices();
    }

    @Override
    public KubernetesListMixedOperation lists() {
        return this.delegate.lists();
    }

    @Override
    public MixedOperation<ConfigMap, ConfigMapList, Resource<ConfigMap>> configMaps() {
        return this.delegate.configMaps();
    }

    @Override
    public MixedOperation<LimitRange, LimitRangeList, Resource<LimitRange>> limitRanges() {
        return this.delegate.limitRanges();
    }

    @Override
    public <T extends CustomResource> MixedOperation<T, KubernetesResourceList<T>, Resource<T>> customResources(Class<T> resourceType) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrdContext(CustomResourceDefinitionContext.fromCustomResourceType(resourceType)).withType(resourceType));
    }

    @Override
    public <T extends CustomResource, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(Class<T> resourceType, Class<L> listClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrdContext(CustomResourceDefinitionContext.fromCustomResourceType(resourceType)).withType(resourceType).withListType(listClass));
    }

    @Override
    public <T extends HasMetadata, L extends KubernetesResourceList<T>> MixedOperation<T, L, Resource<T>> customResources(CustomResourceDefinitionContext crdContext, Class<T> resourceType, Class<L> listClass) {
        return new CustomResourceOperationsImpl(new CustomResourceOperationContext().withOkhttpClient(this.httpClient).withConfig(this.getConfiguration()).withCrdContext(crdContext).withType(resourceType).withListType(listClass));
    }

    @Override
    public DiscoveryAPIGroupDSL discovery() {
        return this.delegate.discovery();
    }

    @Override
    public EventingAPIGroupDSL events() {
        return this.delegate.events();
    }

    @Override
    public ApiextensionsAPIGroupDSL apiextensions() {
        return this.delegate.apiextensions();
    }

    @Override
    public NonNamespaceOperation<CertificateSigningRequest, CertificateSigningRequestList, Resource<CertificateSigningRequest>> certificateSigningRequests() {
        return this.delegate.certificateSigningRequests();
    }

    @Override
    public CertificatesAPIGroupDSL certificates() {
        return this.delegate.certificates();
    }

    @Override
    public AuthorizationAPIGroupDSL authorization() {
        return this.delegate.authorization();
    }

    @Override
    public Createable<TokenReview> tokenReviews() {
        return this.delegate.tokenReviews();
    }

    @Override
    public RawCustomResourceOperationsImpl customResource(CustomResourceDefinitionContext customResourceDefinition) {
        return new RawCustomResourceOperationsImpl(this.httpClient, this.getConfiguration(), customResourceDefinition);
    }

    @Override
    public MixedOperation<Build, BuildList, BuildResource<Build, LogWatch>> builds() {
        return new BuildOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<BuildConfig, BuildConfigList, BuildConfigResource<BuildConfig, Void, Build>> buildConfigs() {
        return new BuildConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<DeploymentConfig, DeploymentConfigList, DeployableScalableResource<DeploymentConfig>> deploymentConfigs() {
        return new DeploymentConfigOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    public MixedOperation<Group, GroupList, Resource<Group>> groups() {
        return new GroupOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<Image, ImageList, Resource<Image>> images() {
        return new ImageOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageTag, ImageTagList, Resource<ImageTag>> imageTags() {
        return new ImageTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageStream, ImageStreamList, Resource<ImageStream>> imageStreams() {
        return new ImageStreamOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ImageStreamTag, ImageStreamTagList, Resource<ImageStreamTag>> imageStreamTags() {
        return new ImageStreamTagOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAccessToken, OAuthAccessTokenList, Resource<OAuthAccessToken>> oAuthAccessTokens() {
        return new OAuthAccessTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthAuthorizeToken, OAuthAuthorizeTokenList, Resource<OAuthAuthorizeToken>> oAuthAuthorizeTokens() {
        return new OAuthAuthorizeTokenOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<OAuthClient, OAuthClientList, Resource<OAuthClient>> oAuthClients() {
        return new OAuthClientOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectOperation projects() {
        return new ProjectOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public OpenShiftQuotaAPIGroupDSL quotas() {
        return this.adapt(OpenShiftQuotaAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<RangeAllocation, RangeAllocationList, Resource<RangeAllocation>> rangeAllocations() {
        return new RangeAllocationOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<SecurityContextConstraints, SecurityContextConstraintsList, Resource<SecurityContextConstraints>> securityContextConstraints() {
        return new SecurityContextConstraintsOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ProjectRequestOperation projectrequests() {
        return new ProjectRequestsOperationImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Role, RoleList, Resource<Role>> roles() {
        return new RoleOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<RoleBinding, RoleBindingList, Resource<RoleBinding>> roleBindings() {
        return new RoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<Route, RouteList, Resource<Route>> routes() {
        return new RouteOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public ParameterMixedOperation<Template, TemplateList, TemplateResource<Template, KubernetesList>> templates() {
        return new TemplateOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    public MixedOperation<User, UserList, Resource<User>> users() {
        return new UserOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<ClusterRoleBinding, ClusterRoleBindingList, Resource<ClusterRoleBinding>> clusterRoleBindings() {
        return new ClusterRoleBindingOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NamespacedOpenShiftClient inNamespace(String namespace) {
        OpenShiftConfig updated = ((OpenShiftConfigBuilder)((OpenShiftConfigBuilder)new OpenShiftConfigBuilder(new OpenShiftConfig(this.getConfiguration())).withOpenShiftUrl(this.openShiftUrl.toString())).withNamespace(namespace)).build();
        return new DefaultOpenShiftClient(this.httpClient, updated);
    }

    @Override
    public NamespacedOpenShiftClient inAnyNamespace() {
        return this.inNamespace(null);
    }

    @Override
    public ExtensionsAPIGroupClient extensions() {
        return this.adapt(ExtensionsAPIGroupClient.class);
    }

    @Override
    public VersionInfo getVersion() {
        VersionInfo versionInfo = new OpenShiftClusterOperationsImpl(this.httpClient, this.getConfiguration(), "version/openshift").fetchVersion();
        return versionInfo == null ? DefaultKubernetesClient.getVersion(this) : versionInfo;
    }

    @Override
    public V1APIGroupDSL v1() {
        return this.adapt(V1APIGroupClient.class);
    }

    @Override
    public RunOperations run() {
        return new RunOperations(this.httpClient, this.getConfiguration(), this.getNamespace(), new RunConfigBuilder());
    }

    @Override
    public NonNamespaceOperation<RuntimeClass, RuntimeClassList, Resource<RuntimeClass>> runtimeClasses() {
        return this.delegate.runtimeClasses();
    }

    @Override
    public AdmissionRegistrationAPIGroupDSL admissionRegistration() {
        return this.adapt(AdmissionRegistrationAPIGroupClient.class);
    }

    @Override
    public AppsAPIGroupDSL apps() {
        return this.adapt(AppsAPIGroupClient.class);
    }

    @Override
    public AutoscalingAPIGroupDSL autoscaling() {
        return this.adapt(AutoscalingAPIGroupClient.class);
    }

    @Override
    public OpenShiftMonitoringAPIGroupDSL monitoring() {
        return this.adapt(OpenShiftMonitoringAPIGroupClient.class);
    }

    @Override
    public NonNamespaceOperation<NetNamespace, NetNamespaceList, Resource<NetNamespace>> netNamespaces() {
        return new NetNamespaceOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NonNamespaceOperation<ClusterNetwork, ClusterNetworkList, Resource<ClusterNetwork>> clusterNetworks() {
        return new ClusterNetworkOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public MixedOperation<EgressNetworkPolicy, EgressNetworkPolicyList, Resource<EgressNetworkPolicy>> egressNetworkPolicies() {
        return new EgressNetworkPolicyOperationsImpl(this.httpClient, OpenShiftConfig.wrap(this.getConfiguration()));
    }

    @Override
    public NetworkAPIGroupDSL network() {
        return this.adapt(NetworkAPIGroupClient.class);
    }

    @Override
    public StorageAPIGroupDSL storage() {
        return this.adapt(StorageAPIGroupClient.class);
    }

    @Override
    public InOutCreateable<SubjectAccessReview, SubjectAccessReviewResponse> subjectAccessReviews() {
        return new OpenShiftSubjectAccessReviewOperationsImpl(this.httpClient, this.getConfiguration(), "authorization.openshift.io", "v1", HasMetadata.getPlural(SubjectAccessReview.class));
    }

    @Override
    public OpenShiftLocalSubjectAccessReviewOperationsImpl localSubjectAccessReviews() {
        return new OpenShiftLocalSubjectAccessReviewOperationsImpl(this.httpClient, this.getConfiguration(), "authorization.openshift.io", "v1", HasMetadata.getPlural(LocalSubjectAccessReview.class));
    }

    @Override
    public BatchAPIGroupDSL batch() {
        return this.adapt(BatchAPIGroupClient.class);
    }

    @Override
    public MetricAPIGroupDSL top() {
        return this.adapt(MetricAPIGroupClient.class);
    }

    @Override
    public PolicyAPIGroupDSL policy() {
        return this.adapt(PolicyAPIGroupClient.class);
    }

    @Override
    public RbacAPIGroupDSL rbac() {
        return this.adapt(RbacAPIGroupClient.class);
    }

    @Override
    public SchedulingAPIGroupDSL scheduling() {
        return this.adapt(SchedulingAPIGroupClient.class);
    }

    @Override
    public SharedInformerFactory informers() {
        return new SharedInformerFactory(ForkJoinPool.commonPool(), this.httpClient, this.getConfiguration());
    }

    @Override
    public SharedInformerFactory informers(ExecutorService executorService) {
        return new SharedInformerFactory(executorService, this.httpClient, this.getConfiguration());
    }

    public LeaderElectorBuilder<NamespacedOpenShiftClient> leaderElector() {
        return new LeaderElectorBuilder<NamespacedOpenShiftClient>(this);
    }

    @Override
    public MixedOperation<Lease, LeaseList, Resource<Lease>> leases() {
        return new LeaseOperationsImpl(this.httpClient, this.getConfiguration());
    }

    @Override
    public FunctionCallable<NamespacedOpenShiftClient> withRequestConfig(RequestConfig requestConfig) {
        return new WithRequestCallable<NamespacedOpenShiftClient>(this, requestConfig);
    }

    @Override
    public User currentUser() {
        return (User)((Resource)this.users().withName("~")).get();
    }

    @Override
    public boolean supportsOpenShiftAPIGroup(String apiGroup) {
        List<String> paths;
        String apiGroupPath = "/apis/" + apiGroup;
        RootPaths rootPaths = this.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!Objects.equals("/oapi", path) && !Objects.equals("oapi", path) && !Objects.equals(apiGroupPath, path)) continue;
                return true;
            }
        }
        return false;
    }
}

