/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_3.operator.v1;

import io.fabric8.kubernetes.api.builder.v5_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_3.Nested;
import io.fabric8.openshift.api.model.v5_3.operator.v1.DNSStatus;
import io.fabric8.openshift.api.model.v5_3.operator.v1.DNSStatusFluent;
import io.fabric8.openshift.api.model.v5_3.operator.v1.OperatorCondition;
import io.fabric8.openshift.api.model.v5_3.operator.v1.OperatorConditionBuilder;
import io.fabric8.openshift.api.model.v5_3.operator.v1.OperatorConditionFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class DNSStatusFluentImpl<A extends DNSStatusFluent<A>>
extends BaseFluent<A>
implements DNSStatusFluent<A> {
    private String clusterDomain;
    private String clusterIP;
    private List<OperatorConditionBuilder> conditions = new ArrayList<OperatorConditionBuilder>();

    public DNSStatusFluentImpl() {
    }

    public DNSStatusFluentImpl(DNSStatus instance) {
        this.withClusterDomain(instance.getClusterDomain());
        this.withClusterIP(instance.getClusterIP());
        this.withConditions(instance.getConditions());
    }

    @Override
    public String getClusterDomain() {
        return this.clusterDomain;
    }

    @Override
    public A withClusterDomain(String clusterDomain) {
        this.clusterDomain = clusterDomain;
        return (A)this;
    }

    @Override
    public Boolean hasClusterDomain() {
        return this.clusterDomain != null;
    }

    @Override
    public A withNewClusterDomain(StringBuilder arg1) {
        return this.withClusterDomain(new String(arg1));
    }

    @Override
    public A withNewClusterDomain(int[] arg1, int arg2, int arg3) {
        return this.withClusterDomain(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClusterDomain(char[] arg1) {
        return this.withClusterDomain(new String(arg1));
    }

    @Override
    public A withNewClusterDomain(StringBuffer arg1) {
        return this.withClusterDomain(new String(arg1));
    }

    @Override
    public A withNewClusterDomain(byte[] arg1, int arg2) {
        return this.withClusterDomain(new String(arg1, arg2));
    }

    @Override
    public A withNewClusterDomain(byte[] arg1) {
        return this.withClusterDomain(new String(arg1));
    }

    @Override
    public A withNewClusterDomain(char[] arg1, int arg2, int arg3) {
        return this.withClusterDomain(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClusterDomain(byte[] arg1, int arg2, int arg3) {
        return this.withClusterDomain(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClusterDomain(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withClusterDomain(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewClusterDomain(String arg1) {
        return this.withClusterDomain(new String(arg1));
    }

    @Override
    public String getClusterIP() {
        return this.clusterIP;
    }

    @Override
    public A withClusterIP(String clusterIP) {
        this.clusterIP = clusterIP;
        return (A)this;
    }

    @Override
    public Boolean hasClusterIP() {
        return this.clusterIP != null;
    }

    @Override
    public A withNewClusterIP(StringBuilder arg1) {
        return this.withClusterIP(new String(arg1));
    }

    @Override
    public A withNewClusterIP(int[] arg1, int arg2, int arg3) {
        return this.withClusterIP(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClusterIP(char[] arg1) {
        return this.withClusterIP(new String(arg1));
    }

    @Override
    public A withNewClusterIP(StringBuffer arg1) {
        return this.withClusterIP(new String(arg1));
    }

    @Override
    public A withNewClusterIP(byte[] arg1, int arg2) {
        return this.withClusterIP(new String(arg1, arg2));
    }

    @Override
    public A withNewClusterIP(byte[] arg1) {
        return this.withClusterIP(new String(arg1));
    }

    @Override
    public A withNewClusterIP(char[] arg1, int arg2, int arg3) {
        return this.withClusterIP(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClusterIP(byte[] arg1, int arg2, int arg3) {
        return this.withClusterIP(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewClusterIP(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withClusterIP(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewClusterIP(String arg1) {
        return this.withClusterIP(new String(arg1));
    }

    @Override
    public A addToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, OperatorCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
        }
        OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(OperatorCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<OperatorCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
        }
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(OperatorCondition ... items) {
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<OperatorCondition> items) {
        for (OperatorCondition item : items) {
            OperatorConditionBuilder builder = new OperatorConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<OperatorConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<OperatorConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            OperatorConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<OperatorCondition> getConditions() {
        return DNSStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<OperatorCondition> buildConditions() {
        return DNSStatusFluentImpl.build(this.conditions);
    }

    @Override
    public OperatorCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public OperatorCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public OperatorCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public OperatorCondition buildMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        for (OperatorConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<OperatorCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<OperatorConditionBuilder>();
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(OperatorCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (OperatorCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public A addNewCondition(String lastTransitionTime, String message, String reason, String status, String type) {
        return this.addToConditions(new OperatorCondition(lastTransitionTime, message, reason, status, type));
    }

    @Override
    public DNSStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public DNSStatusFluent.ConditionsNested<A> addNewConditionLike(OperatorCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public DNSStatusFluent.ConditionsNested<A> setNewConditionLike(int index, OperatorCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public DNSStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DNSStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public DNSStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public DNSStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<OperatorConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DNSStatusFluentImpl that = (DNSStatusFluentImpl)o;
        if (this.clusterDomain != null ? !this.clusterDomain.equals(that.clusterDomain) : that.clusterDomain != null) {
            return false;
        }
        if (this.clusterIP != null ? !this.clusterIP.equals(that.clusterIP) : that.clusterIP != null) {
            return false;
        }
        return !(this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null);
    }

    public int hashCode() {
        return Objects.hash(this.clusterDomain, this.clusterIP, this.conditions, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends OperatorConditionFluentImpl<DNSStatusFluent.ConditionsNested<N>>
    implements DNSStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final OperatorConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, OperatorCondition item) {
            this.index = index;
            this.builder = new OperatorConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new OperatorConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)DNSStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

