/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.utils;

import io.fabric8.kubernetes.api.model.v5_3.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_3.utils.Utils;

public class ApiVersionUtil {
    public static <T> String apiGroup(T item, String apiGroup) {
        if (item instanceof HasMetadata && Utils.isNotNullOrEmpty(((HasMetadata)item).getApiVersion())) {
            return ApiVersionUtil.trimGroupOrNull(((HasMetadata)item).getApiVersion());
        }
        if (apiGroup != null && !apiGroup.isEmpty()) {
            return ApiVersionUtil.trimGroup(apiGroup);
        }
        return null;
    }

    public static <T> String apiVersion(T item, String apiVersion) {
        if (item instanceof HasMetadata && Utils.isNotNullOrEmpty(((HasMetadata)item).getApiVersion())) {
            return ApiVersionUtil.trimVersion(((HasMetadata)item).getApiVersion());
        }
        if (apiVersion != null && !apiVersion.isEmpty()) {
            return ApiVersionUtil.trimVersion(apiVersion);
        }
        return null;
    }

    public static String trimVersion(String apiVersion) {
        int slash;
        if (apiVersion != null && (slash = apiVersion.indexOf(47)) > 0) {
            return apiVersion.substring(slash + 1);
        }
        return apiVersion;
    }

    public static String trimGroup(String apiVersion) {
        int slash;
        if (apiVersion != null && (slash = apiVersion.indexOf(47)) > 0) {
            return apiVersion.substring(0, slash);
        }
        return apiVersion;
    }

    public static String trimGroupOrNull(String apiVersion) {
        if (apiVersion != null && apiVersion.contains("/")) {
            return ApiVersionUtil.trimGroup(apiVersion);
        }
        return null;
    }
}

