/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.handlers.rbac.v1;

import io.fabric8.kubernetes.api.model.v5_3.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_3.ListOptions;
import io.fabric8.kubernetes.api.model.v5_3.rbac.Role;
import io.fabric8.kubernetes.api.model.v5_3.rbac.RoleBuilder;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_3.Watch;
import io.fabric8.kubernetes.clnt.v5_3.Watcher;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.rbac.v1.RoleOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class RoleHandler
implements ResourceHandler<Role, RoleBuilder> {
    @Override
    public String getKind() {
        return Role.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
    }

    @Override
    public Role create(OkHttpClient client, Config config, String namespace, Role item, boolean dryRun) {
        return (Role)((WritableOperation)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new Role[0]);
    }

    @Override
    public Role replace(OkHttpClient client, Config config, String namespace, Role item, boolean dryRun) {
        return ((WritableOperation)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public Role reload(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)((Gettable)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public RoleBuilder edit(Role item) {
        return new RoleBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, Role item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new RoleOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, Watcher<Role> watcher) {
        return ((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, String resourceVersion, Watcher<Role> watcher) {
        return ((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, ListOptions options, Watcher<Role> watcher) {
        return ((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Role waitUntilReady(OkHttpClient client, Config config, String namespace, Role item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Role)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Role waitUntilCondition(OkHttpClient client, Config config, String namespace, Role item, Predicate<Role> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Role)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

