/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.handlers.networking.v1;

import io.fabric8.kubernetes.api.model.v5_3.DeletionPropagation;
import io.fabric8.kubernetes.api.model.v5_3.ListOptions;
import io.fabric8.kubernetes.api.model.v5_3.networking.v1.IngressClass;
import io.fabric8.kubernetes.api.model.v5_3.networking.v1.IngressClassBuilder;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.ResourceHandler;
import io.fabric8.kubernetes.clnt.v5_3.Watch;
import io.fabric8.kubernetes.clnt.v5_3.Watcher;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Deletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.EditReplacePatchDeletable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Gettable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Resource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.WritableOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.networking.v1.IngressClassOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class IngressClassHandler
implements ResourceHandler<IngressClass, IngressClassBuilder> {
    @Override
    public String getKind() {
        return IngressClass.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "networking.k8s.io/v1";
    }

    @Override
    public IngressClass create(OkHttpClient client, Config config, String namespace, IngressClass item, boolean dryRun) {
        return (IngressClass)((WritableOperation)new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun)).create(new IngressClass[0]);
    }

    @Override
    public IngressClass replace(OkHttpClient client, Config config, String namespace, IngressClass item, boolean dryRun) {
        return ((WritableOperation)((Resource)new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).dryRun(dryRun)).replace(item);
    }

    @Override
    public IngressClass reload(OkHttpClient client, Config config, String namespace, IngressClass item) {
        return (IngressClass)((Gettable)((Resource)new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public IngressClassBuilder edit(IngressClass item) {
        return new IngressClassBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, IngressClass item, boolean dryRun) {
        return ((Deletable)((EditReplacePatchDeletable)new IngressClassOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy)).withGracePeriod(gracePeriodSeconds)).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, IngressClass item, Watcher<IngressClass> watcher) {
        return ((Resource)new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, IngressClass item, String resourceVersion, Watcher<IngressClass> watcher) {
        return ((Resource)new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, IngressClass item, ListOptions options, Watcher<IngressClass> watcher) {
        return ((Resource)new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public IngressClass waitUntilReady(OkHttpClient client, Config config, String namespace, IngressClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (IngressClass)((Resource)new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public IngressClass waitUntilCondition(OkHttpClient client, Config config, String namespace, IngressClass item, Predicate<IngressClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (IngressClass)((Resource)new IngressClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

