/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.dsl.internal.apps.v1;

import io.fabric8.kubernetes.api.builder.v5_3.Visitor;
import io.fabric8.kubernetes.api.model.v5_3.Container;
import io.fabric8.kubernetes.api.model.v5_3.OwnerReference;
import io.fabric8.kubernetes.api.model.v5_3.Status;
import io.fabric8.kubernetes.api.model.v5_3.apps.Deployment;
import io.fabric8.kubernetes.api.model.v5_3.apps.DeploymentBuilder;
import io.fabric8.kubernetes.api.model.v5_3.apps.DeploymentList;
import io.fabric8.kubernetes.api.model.v5_3.apps.ReplicaSet;
import io.fabric8.kubernetes.api.model.v5_3.apps.ReplicaSetList;
import io.fabric8.kubernetes.api.model.v5_3.extensions.DeploymentRollback;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_3.dsl.ImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.LogWatch;
import io.fabric8.kubernetes.clnt.v5_3.dsl.Loggable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.RollableScalableResource;
import io.fabric8.kubernetes.clnt.v5_3.dsl.TimeoutImageEditReplacePatchable;
import io.fabric8.kubernetes.clnt.v5_3.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.RollingOperationContext;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.apps.v1.DeploymentRollingUpdater;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.apps.v1.ReplicaSetOperationsImpl;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.apps.v1.RollableScalableResourceOperation;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.apps.v1.RollingUpdater;
import io.fabric8.kubernetes.clnt.v5_3.utils.KubernetesResourceUtil;
import io.fabric8.kubernetes.clnt.v5_3.utils.Utils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeploymentOperationsImpl
extends RollableScalableResourceOperation<Deployment, DeploymentList, RollableScalableResource<Deployment>>
implements TimeoutImageEditReplacePatchable<Deployment> {
    static final transient Logger LOG = LoggerFactory.getLogger(DeploymentOperationsImpl.class);
    public static final String DEPLOYMENT_KUBERNETES_IO_REVISION = "deployment.kubernetes.io/revision";
    private Integer podLogWaitTimeout;

    public DeploymentOperationsImpl(OkHttpClient client, Config config) {
        this(client, config, null);
    }

    public DeploymentOperationsImpl(OkHttpClient client, Config config, String namespace) {
        this(new RollingOperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
        if (config.getNamespace() != null) {
            this.namespace = config.getNamespace();
        }
    }

    public DeploymentOperationsImpl(RollingOperationContext context) {
        super(context.withApiGroupName("apps").withApiGroupVersion("v1").withPlural("deployments"));
        this.type = Deployment.class;
        this.listType = DeploymentList.class;
    }

    private DeploymentOperationsImpl(RollingOperationContext context, Integer podLogWaitTimeout) {
        this(context);
        this.podLogWaitTimeout = podLogWaitTimeout;
    }

    public DeploymentOperationsImpl newInstance(OperationContext context) {
        return new DeploymentOperationsImpl((RollingOperationContext)context);
    }

    @Override
    public Deployment scale(int count) {
        return this.scale(count, false);
    }

    @Override
    public Deployment scale(int count, boolean wait) {
        Deployment res = this.cascading(false).accept((T d) -> d.getSpec().setReplicas(count));
        if (wait) {
            this.waitUntilDeploymentIsScaled(count);
            res = (Deployment)this.getMandatory();
        }
        return res;
    }

    @Override
    public Deployment edit(UnaryOperator<Deployment> function) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).edit(function);
        }
        return (Deployment)super.edit((UnaryOperator)function);
    }

    @Override
    public Deployment accept(Consumer<Deployment> consumer) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).accept(consumer);
        }
        return (Deployment)super.accept((Consumer)consumer);
    }

    @Override
    public Deployment replace(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).replace(item);
        }
        return super.replace(item);
    }

    @Override
    public Deployment patch(Deployment item) {
        if (this.isCascading().booleanValue()) {
            return this.cascading(false).patch(item);
        }
        return super.patch(item);
    }

    @Override
    public DeploymentOperationsImpl rolling() {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRolling(true));
    }

    @Override
    public Status rollback(DeploymentRollback rollback) {
        return this.handleDeploymentRollback(rollback);
    }

    @Override
    public RollingUpdater<Deployment, DeploymentList> getRollingUpdater(long rollingTimeout, TimeUnit rollingTimeUnit) {
        return new DeploymentRollingUpdater(this.client, this.config, this.getNamespace(), rollingTimeUnit.toMillis(rollingTimeout), this.config.getLoggingInterval());
    }

    @Override
    public Deployment withReplicas(int count) {
        return this.cascading(false).accept((T d) -> d.getSpec().setReplicas(count));
    }

    @Override
    public int getCurrentReplicas(Deployment current) {
        return current.getStatus().getReplicas();
    }

    @Override
    public int getDesiredReplicas(Deployment item) {
        return item.getSpec().getReplicas();
    }

    @Override
    public long getObservedGeneration(Deployment current) {
        return current != null && current.getStatus() != null && current.getStatus().getObservedGeneration() != null ? current.getStatus().getObservedGeneration() : -1L;
    }

    @Override
    public Deployment updateImage(String image) {
        Deployment oldRC = (Deployment)this.get();
        if (oldRC == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().size() > 1) {
            throw new KubernetesClientException("updateImage(image) does not supported for multicontainer pods, use updateImage(Map<String, String>) instead");
        }
        if (oldRC.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        Container container = oldRC.getSpec().getTemplate().getSpec().getContainers().iterator().next();
        return this.updateImage((Map)Collections.singletonMap(container.getName(), image));
    }

    @Override
    public Deployment updateImage(Map<String, String> containerToImageMap) {
        Deployment deployment = (Deployment)this.get();
        if (deployment == null) {
            throw new KubernetesClientException("Existing replica set doesn't exist");
        }
        if (deployment.getSpec().getTemplate().getSpec().getContainers().isEmpty()) {
            throw new KubernetesClientException("Pod has no containers!");
        }
        List<Container> containers = deployment.getSpec().getTemplate().getSpec().getContainers();
        for (Container container : containers) {
            if (!containerToImageMap.containsKey(container.getName())) continue;
            container.setImage(containerToImageMap.get(container.getName()));
        }
        deployment.getSpec().getTemplate().getSpec().setContainers(containers);
        return this.sendPatchedObject(this.get(), deployment);
    }

    @Override
    public Deployment resume() {
        return this.sendPatchedDeployment(RollingUpdater.requestPayLoadForRolloutResume());
    }

    @Override
    public Deployment pause() {
        return this.sendPatchedDeployment(RollingUpdater.requestPayLoadForRolloutPause());
    }

    @Override
    public Deployment restart() {
        return this.sendPatchedDeployment(RollingUpdater.requestPayLoadForRolloutRestart());
    }

    @Override
    public Deployment undo() {
        List<ReplicaSet> replicaSets = this.getReplicaSetListForDeployment((Deployment)this.get()).getItems();
        replicaSets.sort((o1, o2) -> {
            String revisionO1 = o1.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION);
            String revisionO2 = o2.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION);
            return Integer.parseInt(revisionO2) - Integer.parseInt(revisionO1);
        });
        ReplicaSet latestReplicaSet = replicaSets.get(0);
        ReplicaSet previousRevisionReplicaSet = replicaSets.get(1);
        Deployment deployment = (Deployment)this.get();
        deployment.getMetadata().getAnnotations().put(DEPLOYMENT_KUBERNETES_IO_REVISION, latestReplicaSet.getMetadata().getAnnotations().get(DEPLOYMENT_KUBERNETES_IO_REVISION));
        deployment.getSpec().setTemplate(previousRevisionReplicaSet.getSpec().getTemplate());
        return this.sendPatchedObject(this.get(), deployment);
    }

    @Override
    public ImageEditReplacePatchable<Deployment> withTimeoutInMillis(long timeoutInMillis) {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRollingTimeout(timeoutInMillis));
    }

    @Override
    public ImageEditReplacePatchable<Deployment> withTimeout(long timeout, TimeUnit unit) {
        return new DeploymentOperationsImpl(((RollingOperationContext)this.context).withRollingTimeUnit(unit));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitUntilDeploymentIsScaled(int count) {
        ArrayBlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);
        AtomicReference<Integer> replicasRef = new AtomicReference<Integer>(0);
        String name = this.checkName(this.getItem());
        String namespace = this.checkNamespace(this.getItem());
        Runnable deploymentPoller = () -> {
            try {
                long observedGeneration;
                Deployment deployment = (Deployment)this.get();
                if (deployment == null) {
                    if (count == 0) {
                        queue.put(true);
                        return;
                    }
                    queue.put(new IllegalStateException("Can't wait for Deployment: " + this.checkName(this.getItem()) + " in namespace: " + this.checkName(this.getItem()) + " to scale. Resource is no longer available."));
                    return;
                }
                replicasRef.set(deployment.getStatus().getReplicas());
                int currentReplicas = deployment.getStatus().getReplicas() != null ? deployment.getStatus().getReplicas() : 0;
                long generation = deployment.getMetadata().getGeneration() != null ? deployment.getMetadata().getGeneration() : 0L;
                long l = observedGeneration = deployment.getStatus() != null && deployment.getStatus().getObservedGeneration() != null ? deployment.getStatus().getObservedGeneration() : -1L;
                if (observedGeneration >= generation && Objects.equals(deployment.getSpec().getReplicas(), currentReplicas)) {
                    queue.put(true);
                } else {
                    LOG.debug("Only {}/{} pods scheduled for Deployment: {} in namespace: {} seconds so waiting...", new Object[]{deployment.getStatus().getReplicas(), deployment.getSpec().getReplicas(), deployment.getMetadata().getName(), namespace});
                }
            }
            catch (Throwable t) {
                LOG.error("Error while waiting for Deployment to be scaled.", t);
            }
        };
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        ScheduledFuture<?> poller = executor.scheduleWithFixedDelay(deploymentPoller, 0L, 100L, TimeUnit.MILLISECONDS);
        try {
            if (Utils.waitUntilReady(queue, this.getConfig().getScaleTimeout(), TimeUnit.MILLISECONDS)) {
                LOG.debug("{}/{} pod(s) ready for Deployment: {} in namespace: {}.", new Object[]{replicasRef.get(), count, name, namespace});
            } else {
                LOG.error("{}/{} pod(s) ready for Deployment: {} in namespace: {}  after waiting for {} seconds so giving up", new Object[]{replicasRef.get(), count, name, namespace, TimeUnit.MILLISECONDS.toSeconds(this.getConfig().getScaleTimeout())});
            }
        }
        finally {
            poller.cancel(true);
            executor.shutdown();
        }
    }

    @Override
    public String getLog() {
        return this.getLog(false);
    }

    @Override
    public String getLog(Boolean isPretty) {
        StringBuilder stringBuilder = new StringBuilder();
        List<RollableScalableResource<ReplicaSet>> rcList = this.doGetLog();
        for (RollableScalableResource<ReplicaSet> rcOperation : rcList) {
            stringBuilder.append(rcOperation.getLog(isPretty));
        }
        return stringBuilder.toString();
    }

    private List<RollableScalableResource<ReplicaSet>> doGetLog() {
        ArrayList<RollableScalableResource<ReplicaSet>> rcs = new ArrayList<RollableScalableResource<ReplicaSet>>();
        Deployment deployment = (Deployment)this.fromServer().get();
        String rcUid = deployment.getMetadata().getUid();
        ReplicaSetOperationsImpl rsOperations = new ReplicaSetOperationsImpl(new RollingOperationContext(this.context.getClient(), this.context.getConfig(), this.context.getPlural(), this.context.getNamespace(), null, this.context.getApiGroupName(), this.context.getApiGroupVersion(), this.context.getCascading(), null, this.context.getLabels(), this.context.getLabelsNot(), this.context.getLabelsIn(), this.context.getLabelsNotIn(), this.context.getFields(), this.context.getFieldsNot(), this.context.getResourceVersion(), this.context.isReloadingFromServer(), this.context.getGracePeriodSeconds(), this.context.getPropagationPolicy(), this.context.getWatchRetryInitialBackoffMillis(), this.context.getWatchRetryBackoffMultiplier(), false, 0L, null, this.context.isNamespaceFromGlobalConfig(), this.context.getDryRun()), this.podLogWaitTimeout);
        ReplicaSetList rcList = (ReplicaSetList)rsOperations.withLabels((Map)DeploymentOperationsImpl.getDeploymentSelectorLabels(deployment)).list();
        for (ReplicaSet rs : rcList.getItems()) {
            OwnerReference ownerReference = KubernetesResourceUtil.getControllerUid(rs);
            if (ownerReference == null || !ownerReference.getUid().equals(rcUid)) continue;
            rcs.add((RollableScalableResource<ReplicaSet>)rsOperations.withName(rs.getMetadata().getName()));
        }
        return rcs;
    }

    @Override
    public Reader getLogReader() {
        List<RollableScalableResource<ReplicaSet>> podResources = this.doGetLog();
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Reading logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return podResources.get(0).getLogReader();
        }
        return null;
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        List<RollableScalableResource<ReplicaSet>> podResources = this.doGetLog();
        if (podResources.size() > 1) {
            throw new KubernetesClientException("Watching logs is not supported for multicontainer jobs");
        }
        if (podResources.size() == 1) {
            return (LogWatch)podResources.get(0).watchLog(out);
        }
        return null;
    }

    @Override
    public Loggable<LogWatch> withLogWaitTimeout(Integer logWaitTimeout) {
        return new DeploymentOperationsImpl((RollingOperationContext)this.context, logWaitTimeout);
    }

    @Override
    public Deployment edit(Visitor ... visitors) {
        return this.patch(((DeploymentBuilder)new DeploymentBuilder((Deployment)this.getMandatory()).accept(visitors)).build());
    }

    private Deployment sendPatchedDeployment(Map<String, Object> patchedUpdate) {
        Deployment oldDeployment = (Deployment)this.get();
        try {
            return this.handlePatch(oldDeployment, patchedUpdate);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw KubernetesClientException.launderThrowable(interruptedException);
        }
        catch (IOException | ExecutionException e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private ReplicaSetList getReplicaSetListForDeployment(Deployment deployment) {
        return (ReplicaSetList)new ReplicaSetOperationsImpl(this.client, this.config, this.getNamespace()).withLabels((Map)deployment.getSpec().getSelector().getMatchLabels()).list();
    }

    static Map<String, String> getDeploymentSelectorLabels(Deployment deployment) {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (deployment != null && deployment.getSpec() != null && deployment.getSpec().getTemplate() != null && deployment.getSpec().getTemplate().getMetadata() != null) {
            labels.putAll(deployment.getSpec().getTemplate().getMetadata().getLabels());
        }
        return labels;
    }
}

