/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.dsl.internal;

import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.AbstractWatchManager;
import io.fabric8.kubernetes.clnt.v5_3.dsl.internal.WatcherWebSocketListener;
import io.fabric8.kubernetes.clnt.v5_3.utils.Utils;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.WebSocket;

abstract class WebSocketClientRunner<T>
extends AbstractWatchManager.ClientRunner {
    private final AtomicReference<WebSocket> webSocketRef = new AtomicReference();
    private final BlockingQueue<Object> queue = new ArrayBlockingQueue<Object>(1);

    protected WebSocketClientRunner(OkHttpClient client) {
        super(client);
    }

    @Override
    public void run(Request request) {
        this.client().newWebSocket(request, this.newListener(this.queue, this.webSocketRef));
    }

    abstract WatcherWebSocketListener<T> newListener(BlockingQueue<Object> var1, AtomicReference<WebSocket> var2);

    @Override
    public void close() {
        AbstractWatchManager.closeWebSocket(this.webSocketRef.getAndSet(null));
    }

    @Override
    public void waitUntilReady() {
        Utils.waitUntilReady(this.queue, 10L, TimeUnit.SECONDS);
    }
}

