/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.dsl.internal;

import io.fabric8.kubernetes.api.model.v5_3.metrics.v1beta1.PodMetrics;
import io.fabric8.kubernetes.api.model.v5_3.metrics.v1beta1.PodMetricsList;
import io.fabric8.kubernetes.clnt.v5_3.Config;
import io.fabric8.kubernetes.clnt.v5_3.KubernetesClientException;
import io.fabric8.kubernetes.clnt.v5_3.dsl.base.OperationContext;
import io.fabric8.kubernetes.clnt.v5_3.dsl.base.OperationSupport;
import io.fabric8.kubernetes.clnt.v5_3.utils.URLUtils;
import io.fabric8.kubernetes.clnt.v5_3.utils.Utils;
import okhttp3.OkHttpClient;

public class PodMetricOperationsImpl
extends OperationSupport {
    private static String METRIC_ENDPOINT_URL = "apis/metrics.k8s.io/v1beta1";

    public PodMetricOperationsImpl(OkHttpClient client, Config config) {
        super(new OperationContext().withOkhttpClient(client).withConfig(config));
    }

    public PodMetrics metrics(String namespace, String podName) {
        try {
            Utils.checkNotNull(namespace, "Namespace not provided");
            Utils.checkNotNull(podName, "Name not provided");
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL, "namespaces", namespace, "pods", podName);
            return this.handleMetric(resourceUrl, PodMetrics.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public PodMetricsList metrics() {
        try {
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL, "pods");
            return this.handleMetric(resourceUrl, PodMetricsList.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public PodMetricsList metrics(String namespace) {
        try {
            String resourceUrl = URLUtils.join(this.config.getMasterUrl(), METRIC_ENDPOINT_URL, "namespaces", namespace, "pods");
            return this.handleMetric(resourceUrl, PodMetricsList.class);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }
}

