/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.clnt.v5_3.dsl.base;

import io.fabric8.kubernetes.api.model.v5_3.HasMetadata;
import io.fabric8.kubernetes.clnt.v5_3.Watcher;
import io.fabric8.kubernetes.clnt.v5_3.WatcherException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;

public class WaitForConditionWatcher<T extends HasMetadata>
implements Watcher<T> {
    private final Predicate<T> condition;
    private final CompletableFuture<T> future;

    public WaitForConditionWatcher(Predicate<T> condition) {
        this.condition = condition;
        this.future = new CompletableFuture();
    }

    public CompletableFuture<T> getFuture() {
        return this.future;
    }

    @Override
    public void eventReceived(Watcher.Action action, T resource) {
        switch (action) {
            case ADDED: 
            case MODIFIED: {
                if (!this.condition.test(resource)) break;
                this.future.complete(resource);
                break;
            }
            case DELETED: {
                if (this.condition.test(null)) {
                    this.future.complete(null);
                    break;
                }
                this.future.completeExceptionally(new WatcherException("Unexpected deletion of watched resource, will never satisfy condition"));
                break;
            }
            case ERROR: {
                this.future.completeExceptionally(new WatcherException("Action.ERROR received"));
            }
        }
    }

    @Override
    public void onClose(WatcherException cause) {
        this.future.completeExceptionally(cause);
    }

    @Override
    public void onClose() {
        this.future.completeExceptionally(new WatcherException("Watcher closed"));
    }
}

