/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_3.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.v5_3.BaseFluent;
import io.fabric8.kubernetes.api.builder.v5_3.Nested;
import io.fabric8.kubernetes.api.model.v5_3.LabelSelector;
import io.fabric8.kubernetes.api.model.v5_3.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.v5_3.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.v5_3.Quantity;
import io.fabric8.kubernetes.api.model.v5_3.autoscaling.v2beta1.ExternalMetricStatus;
import io.fabric8.kubernetes.api.model.v5_3.autoscaling.v2beta1.ExternalMetricStatusFluent;
import java.util.Objects;

public class ExternalMetricStatusFluentImpl<A extends ExternalMetricStatusFluent<A>>
extends BaseFluent<A>
implements ExternalMetricStatusFluent<A> {
    private Quantity currentAverageValue;
    private Quantity currentValue;
    private String metricName;
    private LabelSelectorBuilder metricSelector;

    public ExternalMetricStatusFluentImpl() {
    }

    public ExternalMetricStatusFluentImpl(ExternalMetricStatus instance) {
        this.withCurrentAverageValue(instance.getCurrentAverageValue());
        this.withCurrentValue(instance.getCurrentValue());
        this.withMetricName(instance.getMetricName());
        this.withMetricSelector(instance.getMetricSelector());
    }

    @Override
    public Quantity getCurrentAverageValue() {
        return this.currentAverageValue;
    }

    @Override
    public A withCurrentAverageValue(Quantity currentAverageValue) {
        this.currentAverageValue = currentAverageValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentAverageValue() {
        return this.currentAverageValue != null;
    }

    @Override
    public A withNewCurrentAverageValue(String amount) {
        return this.withCurrentAverageValue(new Quantity(amount));
    }

    @Override
    public A withNewCurrentAverageValue(String amount, String format) {
        return this.withCurrentAverageValue(new Quantity(amount, format));
    }

    @Override
    public Quantity getCurrentValue() {
        return this.currentValue;
    }

    @Override
    public A withCurrentValue(Quantity currentValue) {
        this.currentValue = currentValue;
        return (A)this;
    }

    @Override
    public Boolean hasCurrentValue() {
        return this.currentValue != null;
    }

    @Override
    public A withNewCurrentValue(String amount) {
        return this.withCurrentValue(new Quantity(amount));
    }

    @Override
    public A withNewCurrentValue(String amount, String format) {
        return this.withCurrentValue(new Quantity(amount, format));
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public A withMetricName(String metricName) {
        this.metricName = metricName;
        return (A)this;
    }

    @Override
    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    @Override
    public A withNewMetricName(StringBuilder arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(int[] arg1, int arg2, int arg3) {
        return this.withMetricName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewMetricName(char[] arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(StringBuffer arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(byte[] arg1, int arg2) {
        return this.withMetricName(new String(arg1, arg2));
    }

    @Override
    public A withNewMetricName(byte[] arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    public A withNewMetricName(char[] arg1, int arg2, int arg3) {
        return this.withMetricName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewMetricName(byte[] arg1, int arg2, int arg3) {
        return this.withMetricName(new String(arg1, arg2, arg3));
    }

    @Override
    public A withNewMetricName(byte[] arg1, int arg2, int arg3, int arg4) {
        return this.withMetricName(new String(arg1, arg2, arg3, arg4));
    }

    @Override
    public A withNewMetricName(String arg1) {
        return this.withMetricName(new String(arg1));
    }

    @Override
    @Deprecated
    public LabelSelector getMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public LabelSelector buildMetricSelector() {
        return this.metricSelector != null ? this.metricSelector.build() : null;
    }

    @Override
    public A withMetricSelector(LabelSelector metricSelector) {
        this._visitables.get("metricSelector").remove(this.metricSelector);
        if (metricSelector != null) {
            this.metricSelector = new LabelSelectorBuilder(metricSelector);
            this._visitables.get("metricSelector").add(this.metricSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasMetricSelector() {
        return this.metricSelector != null;
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelector() {
        return new MetricSelectorNestedImpl();
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item) {
        return new MetricSelectorNestedImpl(item);
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector());
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelector() {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item) {
        return this.withNewMetricSelectorLike(this.getMetricSelector() != null ? this.getMetricSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalMetricStatusFluentImpl that = (ExternalMetricStatusFluentImpl)o;
        if (this.currentAverageValue != null ? !this.currentAverageValue.equals(that.currentAverageValue) : that.currentAverageValue != null) {
            return false;
        }
        if (this.currentValue != null ? !this.currentValue.equals(that.currentValue) : that.currentValue != null) {
            return false;
        }
        if (this.metricName != null ? !this.metricName.equals(that.metricName) : that.metricName != null) {
            return false;
        }
        return !(this.metricSelector != null ? !this.metricSelector.equals(that.metricSelector) : that.metricSelector != null);
    }

    public int hashCode() {
        return Objects.hash(this.currentAverageValue, this.currentValue, this.metricName, this.metricSelector, super.hashCode());
    }

    public class MetricSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<ExternalMetricStatusFluent.MetricSelectorNested<N>>
    implements ExternalMetricStatusFluent.MetricSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        MetricSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        MetricSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)ExternalMetricStatusFluentImpl.this.withMetricSelector(this.builder.build());
        }

        @Override
        public N endMetricSelector() {
            return this.and();
        }
    }
}

