/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.v5_3;

import io.fabric8.kubernetes.api.builder.v5_3.VisitableBuilder;
import io.fabric8.kubernetes.api.model.v5_3.CSIVolumeSource;
import io.fabric8.kubernetes.api.model.v5_3.CSIVolumeSourceFluent;
import io.fabric8.kubernetes.api.model.v5_3.CSIVolumeSourceFluentImpl;
import java.util.Objects;

public class CSIVolumeSourceBuilder
extends CSIVolumeSourceFluentImpl<CSIVolumeSourceBuilder>
implements VisitableBuilder<CSIVolumeSource, CSIVolumeSourceBuilder> {
    CSIVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public CSIVolumeSourceBuilder() {
        this(true);
    }

    public CSIVolumeSourceBuilder(Boolean validationEnabled) {
        this(new CSIVolumeSource(), validationEnabled);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new CSIVolumeSource(), validationEnabled);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent, CSIVolumeSource instance) {
        this(fluent, instance, true);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSourceFluent<?> fluent, CSIVolumeSource instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withDriver(instance.getDriver());
        fluent.withFsType(instance.getFsType());
        fluent.withNodePublishSecretRef(instance.getNodePublishSecretRef());
        fluent.withReadOnly(instance.getReadOnly());
        fluent.withVolumeAttributes(instance.getVolumeAttributes());
        this.validationEnabled = validationEnabled;
    }

    public CSIVolumeSourceBuilder(CSIVolumeSource instance) {
        this(instance, (Boolean)true);
    }

    public CSIVolumeSourceBuilder(CSIVolumeSource instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withDriver(instance.getDriver());
        this.withFsType(instance.getFsType());
        this.withNodePublishSecretRef(instance.getNodePublishSecretRef());
        this.withReadOnly(instance.getReadOnly());
        this.withVolumeAttributes(instance.getVolumeAttributes());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public CSIVolumeSource build() {
        CSIVolumeSource buildable = new CSIVolumeSource(this.fluent.getDriver(), this.fluent.getFsType(), this.fluent.getNodePublishSecretRef(), this.fluent.getReadOnly(), this.fluent.getVolumeAttributes());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CSIVolumeSourceBuilder that = (CSIVolumeSourceBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

