/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.builder.v5_3;

import io.fabric8.kubernetes.api.builder.v5_3.Visitor;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public abstract class TypedVisitor<V>
implements Visitor<V> {
    public Class<V> getType() {
        return TypedVisitor.getTypeArguments(TypedVisitor.class, this.getClass()).get(0);
    }

    private static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return TypedVisitor.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = TypedVisitor.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    static <T> List<Class> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        LinkedHashMap resolvedTypes = new LinkedHashMap();
        Type type = childClass;
        while (!TypedVisitor.getClass(type).equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
                continue;
            }
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
            }
            if (rawType.equals(baseClass)) continue;
            type = rawType.getGenericSuperclass();
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList<Class> typeArgumentsAsClasses = new ArrayList<Class>();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(TypedVisitor.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }
}

