/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.v5_12.operatorhub.v1;

import io.fabric8.kubernetes.api.builder.v5_12.BaseFluent;
import io.fabric8.kubernetes.api.model.v5_12.Condition;
import io.fabric8.openshift.api.model.v5_12.operatorhub.v1.OperatorConditionSpec;
import io.fabric8.openshift.api.model.v5_12.operatorhub.v1.OperatorConditionSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class OperatorConditionSpecFluentImpl<A extends OperatorConditionSpecFluent<A>>
extends BaseFluent<A>
implements OperatorConditionSpecFluent<A> {
    private List<String> deployments = new ArrayList<String>();
    private List<Condition> overrides = new ArrayList<Condition>();
    private List<String> serviceAccounts = new ArrayList<String>();
    private Map<String, Object> additionalProperties;

    public OperatorConditionSpecFluentImpl() {
    }

    public OperatorConditionSpecFluentImpl(OperatorConditionSpec instance) {
        this.withDeployments(instance.getDeployments());
        this.withOverrides(instance.getOverrides());
        this.withServiceAccounts(instance.getServiceAccounts());
        this.withAdditionalProperties(instance.getAdditionalProperties());
    }

    @Override
    public A addToDeployments(Integer index, String item) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        this.deployments.add(index, item);
        return (A)this;
    }

    @Override
    public A setToDeployments(Integer index, String item) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        this.deployments.set(index, item);
        return (A)this;
    }

    @Override
    public A addToDeployments(String ... items) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        for (String item : items) {
            this.deployments.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToDeployments(Collection<String> items) {
        if (this.deployments == null) {
            this.deployments = new ArrayList<String>();
        }
        for (String item : items) {
            this.deployments.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromDeployments(String ... items) {
        for (String item : items) {
            if (this.deployments == null) continue;
            this.deployments.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromDeployments(Collection<String> items) {
        for (String item : items) {
            if (this.deployments == null) continue;
            this.deployments.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getDeployments() {
        return this.deployments;
    }

    @Override
    public String getDeployment(Integer index) {
        return this.deployments.get(index);
    }

    @Override
    public String getFirstDeployment() {
        return this.deployments.get(0);
    }

    @Override
    public String getLastDeployment() {
        return this.deployments.get(this.deployments.size() - 1);
    }

    @Override
    public String getMatchingDeployment(Predicate<String> predicate) {
        for (String item : this.deployments) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingDeployment(Predicate<String> predicate) {
        for (String item : this.deployments) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withDeployments(List<String> deployments) {
        if (deployments != null) {
            this.deployments = new ArrayList<String>();
            for (String item : deployments) {
                this.addToDeployments(item);
            }
        } else {
            this.deployments = null;
        }
        return (A)this;
    }

    @Override
    public A withDeployments(String ... deployments) {
        if (this.deployments != null) {
            this.deployments.clear();
        }
        if (deployments != null) {
            for (String item : deployments) {
                this.addToDeployments(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasDeployments() {
        return this.deployments != null && !this.deployments.isEmpty();
    }

    @Override
    public A addNewDeployment(String arg0) {
        return this.addToDeployments(new String(arg0));
    }

    @Override
    public A addToOverrides(Integer index, Condition item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<Condition>();
        }
        this.overrides.add(index, item);
        return (A)this;
    }

    @Override
    public A setToOverrides(Integer index, Condition item) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<Condition>();
        }
        this.overrides.set(index, item);
        return (A)this;
    }

    @Override
    public A addToOverrides(Condition ... items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.overrides.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToOverrides(Collection<Condition> items) {
        if (this.overrides == null) {
            this.overrides = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.overrides.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromOverrides(Condition ... items) {
        for (Condition item : items) {
            if (this.overrides == null) continue;
            this.overrides.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromOverrides(Collection<Condition> items) {
        for (Condition item : items) {
            if (this.overrides == null) continue;
            this.overrides.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Condition> getOverrides() {
        return this.overrides;
    }

    @Override
    public Condition getOverride(Integer index) {
        return this.overrides.get(index);
    }

    @Override
    public Condition getFirstOverride() {
        return this.overrides.get(0);
    }

    @Override
    public Condition getLastOverride() {
        return this.overrides.get(this.overrides.size() - 1);
    }

    @Override
    public Condition getMatchingOverride(Predicate<Condition> predicate) {
        for (Condition item : this.overrides) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingOverride(Predicate<Condition> predicate) {
        for (Condition item : this.overrides) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withOverrides(List<Condition> overrides) {
        if (overrides != null) {
            this.overrides = new ArrayList<Condition>();
            for (Condition item : overrides) {
                this.addToOverrides(item);
            }
        } else {
            this.overrides = null;
        }
        return (A)this;
    }

    @Override
    public A withOverrides(Condition ... overrides) {
        if (this.overrides != null) {
            this.overrides.clear();
        }
        if (overrides != null) {
            for (Condition item : overrides) {
                this.addToOverrides(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasOverrides() {
        return this.overrides != null && !this.overrides.isEmpty();
    }

    @Override
    public A addToServiceAccounts(Integer index, String item) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList<String>();
        }
        this.serviceAccounts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToServiceAccounts(Integer index, String item) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList<String>();
        }
        this.serviceAccounts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToServiceAccounts(String ... items) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccounts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToServiceAccounts(Collection<String> items) {
        if (this.serviceAccounts == null) {
            this.serviceAccounts = new ArrayList<String>();
        }
        for (String item : items) {
            this.serviceAccounts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromServiceAccounts(String ... items) {
        for (String item : items) {
            if (this.serviceAccounts == null) continue;
            this.serviceAccounts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromServiceAccounts(Collection<String> items) {
        for (String item : items) {
            if (this.serviceAccounts == null) continue;
            this.serviceAccounts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getServiceAccounts() {
        return this.serviceAccounts;
    }

    @Override
    public String getServiceAccount(Integer index) {
        return this.serviceAccounts.get(index);
    }

    @Override
    public String getFirstServiceAccount() {
        return this.serviceAccounts.get(0);
    }

    @Override
    public String getLastServiceAccount() {
        return this.serviceAccounts.get(this.serviceAccounts.size() - 1);
    }

    @Override
    public String getMatchingServiceAccount(Predicate<String> predicate) {
        for (String item : this.serviceAccounts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingServiceAccount(Predicate<String> predicate) {
        for (String item : this.serviceAccounts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withServiceAccounts(List<String> serviceAccounts) {
        if (serviceAccounts != null) {
            this.serviceAccounts = new ArrayList<String>();
            for (String item : serviceAccounts) {
                this.addToServiceAccounts(item);
            }
        } else {
            this.serviceAccounts = null;
        }
        return (A)this;
    }

    @Override
    public A withServiceAccounts(String ... serviceAccounts) {
        if (this.serviceAccounts != null) {
            this.serviceAccounts.clear();
        }
        if (serviceAccounts != null) {
            for (String item : serviceAccounts) {
                this.addToServiceAccounts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasServiceAccounts() {
        return this.serviceAccounts != null && !this.serviceAccounts.isEmpty();
    }

    @Override
    public A addNewServiceAccount(String arg0) {
        return this.addToServiceAccounts(new String(arg0));
    }

    @Override
    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)this;
    }

    @Override
    public Boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperatorConditionSpecFluentImpl that = (OperatorConditionSpecFluentImpl)o;
        if (this.deployments != null ? !this.deployments.equals(that.deployments) : that.deployments != null) {
            return false;
        }
        if (this.overrides != null ? !this.overrides.equals(that.overrides) : that.overrides != null) {
            return false;
        }
        if (this.serviceAccounts != null ? !this.serviceAccounts.equals(that.serviceAccounts) : that.serviceAccounts != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public int hashCode() {
        return Objects.hash(this.deployments, this.overrides, this.serviceAccounts, this.additionalProperties, super.hashCode());
    }
}

